/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import java.io.File;
import java.util.Locale;
import ohos.FileUtils;
import ohos.Log;
import ohos.Utility;

class UncompressVerify {
    private static final String HAP_SUFFIX = ".hap";
    private static final String HAR_SUFFIX = ".har";
    private static final String APP_SUFFIX = ".app";
    private static final String APPQF_SUFFIX = ".appqf";
    private static final String HSP_SUFFIX = ".hsp";
    private static final String FALSE = "false";
    private static final String RPCID_SC = "rpcid.sc";
    private static final String TRUE = "true";
    private static final Log LOG = new Log(UncompressVerify.class.toString());

    UncompressVerify() {
    }

    public static boolean commandVerify(Utility utility) {
        if (!(utility.getForceRewrite().isEmpty() || TRUE.equals(utility.getForceRewrite()) || FALSE.equals(utility.getForceRewrite()))) {
            LOG.error("UncompressVerify::isVerifyVaild forceRewrite is invalid!");
            return false;
        }
        if (!(utility.getParseMode().isEmpty() || "hap-list".equals(utility.getParseMode()) || "hap-info".equals(utility.getParseMode()) || "all".equals(utility.getParseMode()))) {
            LOG.error("UncompressVerify::isVerifyVaild parseMode is invalid!");
            return false;
        }
        if ("hap".equals(utility.getMode())) {
            return UncompressVerify.hapCommandVerify(utility);
        }
        if ("har".equals(utility.getMode())) {
            return UncompressVerify.harCommandVerify(utility);
        }
        if ("app".equals(utility.getMode())) {
            return UncompressVerify.appCommandVerify(utility);
        }
        if ("appqf".equals(utility.getMode())) {
            return UncompressVerify.appqfVerify(utility);
        }
        if ("hsp".equals(utility.getMode())) {
            return UncompressVerify.hspCommandVerify(utility);
        }
        LOG.error("UncompressVerify::commandVerify mode is invalid!");
        return false;
    }

    private static boolean hapCommandVerify(Utility utility) {
        utility.setHapPath(utility.getFormattedPath(utility.getHapPath()));
        File file = new File(utility.getHapPath());
        if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) {
            LOG.error("UncompressVerify::isArgsValidInHapMode hap-path must end with.hap!");
            return false;
        }
        if (!TRUE.equals(utility.getLibs()) && !FALSE.equals(utility.getLibs())) {
            LOG.error("UncompressVerify::isArgsValidInHapMode --libs must be true or false");
            return false;
        }
        if (TRUE.equals(utility.getLibs())) {
            utility.setRpcid(FALSE);
            return UncompressVerify.libsCommandVerify(utility);
        }
        if (!TRUE.equals(utility.getRpcid()) && !FALSE.equals(utility.getRpcid())) {
            LOG.error("UncompressVerify::isArgsValidInHapMode --rpcid must be true or false");
            return false;
        }
        if (TRUE.equals(utility.getRpcid())) {
            return UncompressVerify.rpcidCommandVerify(utility);
        }
        return UncompressVerify.verifyOutPath(utility, file);
    }

    private static boolean hspCommandVerify(Utility utility) {
        utility.setHspPath(utility.getFormattedPath(utility.getHspPath()));
        File file = new File(utility.getHspPath());
        if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX)) {
            LOG.error("UncompressVerify::isArgsValidInHspMode hsp-path must end with.hsp!");
            return false;
        }
        if (!TRUE.equals(utility.getLibs()) && !FALSE.equals(utility.getLibs())) {
            LOG.error("UncompressVerify::isArgsValidInHapMode --libs must be true or false");
            return false;
        }
        if (TRUE.equals(utility.getLibs())) {
            return UncompressVerify.libsCommandVerify(utility);
        }
        return UncompressVerify.verifyOutPath(utility, file);
    }

    private static boolean rpcidCommandVerify(Utility utility) {
        File file = new File(utility.getOutPath(), RPCID_SC);
        if (file.exists() && FALSE.equals(utility.getForceRewrite())) {
            LOG.error("UncompressVerify::rpcidCommandVerify outPath already exists");
            return false;
        }
        return true;
    }

    private static boolean libsCommandVerify(Utility utility) {
        if (utility.getOutPath().isEmpty()) {
            LOG.error("--out-path is empty!");
            return false;
        }
        File file = new File(utility.getOutPath());
        if (FALSE.equals(utility.getForceRewrite()) && file.exists()) {
            LOG.error("UncompressVerify::libsCommandVerify out file already existed!");
            return false;
        }
        if (!utility.getCpuAbis().isEmpty()) {
            String[] stringArray;
            for (String string : stringArray = utility.getCpuAbis().split(",")) {
                if (utility.getFormattedCpuAbiList().contains(string)) continue;
                utility.getFormattedCpuAbiList().add(string);
            }
        }
        return true;
    }

    private static boolean harCommandVerify(Utility utility) {
        utility.setHarPath(utility.getFormattedPath(utility.getHarPath()));
        File file = new File(utility.getHarPath());
        if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(HAR_SUFFIX)) {
            LOG.error("UncompressVerify::isArgsValidInHarMode har-path must end with.har!");
            return false;
        }
        if (utility.getOutPath().isEmpty()) {
            LOG.error("UncompressVerify::isVerifyVaild outPath is invalid!");
            return false;
        }
        return UncompressVerify.verifyOutPath(utility, file);
    }

    private static boolean appCommandVerify(Utility utility) {
        if ("hap-info".equals(utility.getParseMode()) && utility.getHapName().isEmpty()) {
            LOG.error("UncompressVerify::isArgsVaildInParseMode hapName can't be empty!");
            return false;
        }
        utility.setAppPath(utility.getFormattedPath(utility.getAppPath()));
        File file = new File(utility.getAppPath());
        if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(APP_SUFFIX)) {
            LOG.error("UncompressVerify::appCommandVerify app-path must end with.app!");
            return false;
        }
        return UncompressVerify.verifyOutPath(utility, file);
    }

    private static boolean appqfVerify(Utility utility) {
        utility.setAPPQFPath(utility.getFormattedPath(utility.getAPPQFPath()));
        File file = new File(utility.getAPPQFPath());
        if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(APPQF_SUFFIX)) {
            LOG.error("UncompressVerify::appqfVerify appqf-path is invalid,please check input file is exist or this file is not end with .appqf!");
            return false;
        }
        return UncompressVerify.verifyOutPath(utility, file);
    }

    private static boolean verifyOutPath(Utility utility, File file) {
        if (utility.getOutPath().isEmpty() && !utility.getIsParse()) {
            LOG.error("--out-path is empty!");
            return false;
        }
        File file2 = new File(utility.getOutPath());
        if (FALSE.equals(utility.getForceRewrite()) && file2.exists()) {
            LOG.error("UncompressVerify::isArgsValidInHapMode out file already existed!");
            return false;
        }
        return true;
    }

    public static boolean isPathValid(String string, boolean bl, String string2) {
        if (!FileUtils.matchPattern(string)) {
            LOG.error("Input invalid file " + string);
            return false;
        }
        File file = new File(string);
        if (bl && file.isFile() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(string2)) {
            return true;
        }
        return !bl && file.isDirectory();
    }

    public static boolean isParseAppModeValid(String string, String string2) {
        if (!("hap-list".equals(string) || "hap-info".equals(string) || "all".equals(string))) {
            LOG.error("uncompressVerify parse mode " + string + " is invalid!");
            return false;
        }
        if ("hap-info".equals(string) && string2.isEmpty()) {
            LOG.error("uncompressVerify hapName should not empty when parse mode is hap-info!");
            return false;
        }
        return true;
    }
}

