/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.codesigning.sign;

import com.ohos.hapsigntool.codesigning.datastructure.CodeSignBlock;
import com.ohos.hapsigntool.codesigning.datastructure.CodeSignBlockHeader;
import com.ohos.hapsigntool.codesigning.datastructure.ElfSignBlock;
import com.ohos.hapsigntool.codesigning.datastructure.Extension;
import com.ohos.hapsigntool.codesigning.datastructure.FsVerityInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.HapInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.MerkleTreeExtension;
import com.ohos.hapsigntool.codesigning.datastructure.NativeLibInfoSegment;
import com.ohos.hapsigntool.codesigning.datastructure.SegmentHeader;
import com.ohos.hapsigntool.codesigning.datastructure.SignInfo;
import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.exception.PageInfoException;
import com.ohos.hapsigntool.codesigning.exception.VerifyCodeSignException;
import com.ohos.hapsigntool.codesigning.fsverity.FsVerityGenerator;
import com.ohos.hapsigntool.codesigning.sign.CodeSigning;
import com.ohos.hapsigntool.codesigning.utils.CmsUtils;
import com.ohos.hapsigntool.codesigning.utils.HapUtils;
import com.ohos.hapsigntool.entity.Pair;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class VerifyCodeSignature {
    private static final LogUtils LOGGER = new LogUtils(VerifyCodeSignature.class);

    private static void checkOwnerID(byte[] signature, String profileOwnerID, String profileType) throws CMSException, VerifyCodeSignException {
        String ownerID = profileOwnerID;
        if ("debug".equals(profileType)) {
            ownerID = "DEBUG_LIB_ID";
        }
        VerifyCodeSignature.checkSignatureOwnerID(ownerID, signature, profileType);
    }

    private static void checkHnpOwnerID(byte[] signature, String profileOwnerID, String profileType, String hnpType) throws CMSException, VerifyCodeSignException {
        String ownerID = profileOwnerID;
        if ("debug".equals(profileType)) {
            ownerID = "DEBUG_LIB_ID";
        } else if ("release".equals(profileType) && "public".equals(hnpType)) {
            ownerID = "SHARED_LIB_ID";
        }
        VerifyCodeSignature.checkSignatureOwnerID(ownerID, signature, profileType);
    }

    private static void checkSignatureOwnerID(String ownerID, byte[] signature, String profileType) throws CMSException, VerifyCodeSignException {
        CMSSignedData cmsSignedData = new CMSSignedData(signature);
        Collection<SignerInformation> signers = cmsSignedData.getSignerInfos().getSigners();
        for (SignerInformation signer : signers) {
            AttributeTable attrTable = signer.getSignedAttributes();
            Attribute attr = attrTable.get(new ASN1ObjectIdentifier("1.3.6.1.4.1.2011.2.376.1.4.1"));
            if (attr == null) {
                if ("debug".equals(profileType) || ownerID == null) continue;
                throw new VerifyCodeSignException("app-identifier is not in the signature");
            }
            if (ownerID == null) {
                throw new VerifyCodeSignException("app-identifier in profile is null, but is not null in signature");
            }
            String resultOwnerID = attr.getAttrValues().getObjectAt(0).toString();
            if (ownerID.equals(resultOwnerID)) continue;
            throw new VerifyCodeSignException("app-identifier in signature is invalid");
        }
    }

    public static boolean verifyElf(File file, long offset, long length, String fileFormat, String profileContent) throws IOException, VerifyCodeSignException, FsVerityDigestException, CMSException, ProfileException {
        ElfSignBlock elfSignBlock;
        if (!"elf".equalsIgnoreCase(fileFormat)) {
            LOGGER.info("Not elf file, skip code signing verify");
            return true;
        }
        try (FileInputStream signedElf = new FileInputStream(file);){
            byte[] codeSignBlockBytes = new byte[(int)length];
            signedElf.skip(offset);
            signedElf.read(codeSignBlockBytes);
            elfSignBlock = ElfSignBlock.fromByteArray(codeSignBlockBytes);
        }
        signedElf = new FileInputStream(file);
        var9_6 = null;
        try {
            int paddingSize = ElfSignBlock.computeMerkleTreePaddingLength(offset);
            byte[] merkleTreeWithPadding = elfSignBlock.getMerkleTreeWithPadding();
            byte[] merkleTree = Arrays.copyOfRange(merkleTreeWithPadding, paddingSize, merkleTreeWithPadding.length);
            VerifyCodeSignature.verifySingleFile(signedElf, elfSignBlock.getDataSize(), elfSignBlock.getSignature(), elfSignBlock.getTreeOffset(), merkleTree);
        }
        catch (Throwable throwable) {
            var9_6 = throwable;
            throw throwable;
        }
        finally {
            if (signedElf != null) {
                if (var9_6 != null) {
                    try {
                        signedElf.close();
                    }
                    catch (Throwable throwable) {
                        var9_6.addSuppressed(throwable);
                    }
                } else {
                    signedElf.close();
                }
            }
        }
        if (profileContent != null) {
            Pair<String, String> pairResult = HapUtils.parseAppIdentifier(profileContent);
            VerifyCodeSignature.checkOwnerID(elfSignBlock.getSignature(), pairResult.getFirst(), pairResult.getSecond());
        }
        return true;
    }

    public static boolean verifyHap(File file, long offset, long length, String fileFormat, String profileContent) throws IOException, VerifyCodeSignException, FsVerityDigestException, CMSException, ProfileException {
        if (!StringUtils.containsIgnoreCase(CodeSigning.SUPPORT_FILE_FORM, fileFormat)) {
            LOGGER.info("Not hap, hsp or hqf file, skip code signing verify");
            return true;
        }
        Pair<String, String> pairResult = HapUtils.parseAppIdentifier(profileContent);
        CodeSignBlock csb = VerifyCodeSignature.generateCodeSignBlock(file, offset, length);
        try (FileInputStream hap = new FileInputStream(file);){
            long dataSize = csb.getHapInfoSegment().getSignInfo().getDataSize();
            byte[] signature = csb.getHapInfoSegment().getSignInfo().getSignature();
            Extension extension = csb.getHapInfoSegment().getSignInfo().getExtensionByType(1);
            MerkleTreeExtension mte = new MerkleTreeExtension(0L, 0L, null);
            if (extension instanceof MerkleTreeExtension) {
                mte = (MerkleTreeExtension)extension;
            }
            VerifyCodeSignature.verifySingleFile(hap, dataSize, signature, mte.getMerkleTreeOffset(), csb.getOneMerkleTreeByFileName("Hap"));
            VerifyCodeSignature.checkOwnerID(signature, pairResult.getFirst(), pairResult.getSecond());
        }
        VerifyCodeSignature.verifyLibs(file, csb, pairResult);
        return true;
    }

    private static void verifyLibs(File file, CodeSignBlock csb, Pair<String, String> pairResult) throws IOException, FsVerityDigestException, VerifyCodeSignException, CMSException, ProfileException {
        try (JarFile inputJar = new JarFile(file, false);){
            HashMap<String, SignInfo> hnpLibSignInfoMap = new HashMap<String, SignInfo>();
            HashSet<String> hnpEntryNames = new HashSet<String>();
            for (int i = 0; i < csb.getSoInfoSegment().getSectionNum(); ++i) {
                String entryName = csb.getSoInfoSegment().getFileNameList().get(i);
                SignInfo signInfo = csb.getSoInfoSegment().getSignInfoList().get(i);
                if (entryName.contains("!/")) {
                    String[] filePath = entryName.split("!/");
                    hnpEntryNames.add(filePath[0]);
                    hnpLibSignInfoMap.put(entryName, signInfo);
                    continue;
                }
                LOGGER.info("verify lib: {}", entryName);
                VerifyCodeSignature.verifyHapLib(inputJar, entryName, signInfo, pairResult);
            }
            if (hnpEntryNames.isEmpty()) {
                return;
            }
            Map<String, String> hnpTypeMap = HapUtils.getHnpsFromJson(inputJar);
            for (String hnpEntryName : hnpEntryNames) {
                VerifyCodeSignature.verifyHnpLib(inputJar, hnpEntryName, hnpLibSignInfoMap, hnpTypeMap, pairResult);
            }
        }
    }

    private static void verifyHapLib(JarFile inputJar, String entryName, SignInfo signInfo, Pair<String, String> pairResult) throws IOException, FsVerityDigestException, VerifyCodeSignException, CMSException {
        JarEntry entry = inputJar.getJarEntry(entryName);
        if (entry.getSize() != signInfo.getDataSize()) {
            throw new VerifyCodeSignException(String.format(Locale.ROOT, "Invalid dataSize of native lib %s", entryName));
        }
        byte[] entrySig = signInfo.getSignature();
        try (InputStream entryInputStream = inputJar.getInputStream(entry);){
            VerifyCodeSignature.verifySingleFile(entryInputStream, entry.getSize(), entrySig, 0L, null);
            VerifyCodeSignature.checkOwnerID(entrySig, pairResult.getFirst(), pairResult.getSecond());
        }
    }

    private static void verifyHnpLib(JarFile inputJar, String hnpEntryName, Map<String, SignInfo> hnpLibSignInfoMap, Map<String, String> hnpTypeMap, Pair<String, String> pairResult) throws IOException, FsVerityDigestException, VerifyCodeSignException, CMSException {
        JarEntry hnpEntry = inputJar.getJarEntry(hnpEntryName);
        try (InputStream inputStream = inputJar.getInputStream(hnpEntry);
             ZipInputStream hnpInputStream = new ZipInputStream(inputStream);){
            String hnpFileName = HapUtils.parseHnpPath(hnpEntryName);
            if (!hnpTypeMap.containsKey(hnpFileName)) {
                throw new VerifyCodeSignException("hnp should be described in module.json");
            }
            String hnpType = hnpTypeMap.get(hnpFileName);
            ZipEntry libEntry = null;
            while ((libEntry = hnpInputStream.getNextEntry()) != null) {
                String libPath = hnpEntry.getName() + "!/" + libEntry.getName();
                if (!hnpLibSignInfoMap.containsKey(libPath)) continue;
                LOGGER.info("verify lib: {}", libPath);
                SignInfo signInfo = hnpLibSignInfoMap.get(libPath);
                byte[] entrySig = signInfo.getSignature();
                long dataSize = signInfo.getDataSize();
                VerifyCodeSignature.verifySingleFile(hnpInputStream, dataSize, entrySig, 0L, null);
                VerifyCodeSignature.checkHnpOwnerID(entrySig, pairResult.getFirst(), pairResult.getSecond(), hnpType);
                hnpInputStream.closeEntry();
            }
        }
    }

    private static CodeSignBlock generateCodeSignBlock(File file, long offset, long length) throws IOException, VerifyCodeSignException {
        CodeSignBlock csb = new CodeSignBlock();
        try (FileInputStream signedHap = new FileInputStream(file);){
            int fileReadOffset = 0;
            signedHap.skip(offset);
            byte[] codeSignBlockHeaderByteArray = new byte[CodeSignBlockHeader.size()];
            fileReadOffset += signedHap.read(codeSignBlockHeaderByteArray);
            csb.setCodeSignBlockHeader(CodeSignBlockHeader.fromByteArray(codeSignBlockHeaderByteArray));
            if ((long)csb.getCodeSignBlockHeader().getBlockSize() != length) {
                throw new VerifyCodeSignException("Invalid code Sign block size of setCodeSignBlockHeader");
            }
            for (int i = 0; i < csb.getCodeSignBlockHeader().getSegmentNum(); ++i) {
                byte[] segmentHeaderByteArray = new byte[12];
                fileReadOffset += signedHap.read(segmentHeaderByteArray);
                csb.addToSegmentList(SegmentHeader.fromByteArray(segmentHeaderByteArray));
            }
            long computedTreeOffset = VerifyCodeSignature.getAlignmentAddr(4096L, (long)fileReadOffset + offset);
            fileReadOffset = (int)((long)fileReadOffset + signedHap.skip(computedTreeOffset - offset - (long)fileReadOffset));
            VerifyCodeSignature.parseMerkleTree(csb, fileReadOffset, signedHap, computedTreeOffset);
        }
        return csb;
    }

    private static void parseMerkleTree(CodeSignBlock csb, int readOffset, FileInputStream signedHap, long computedTreeOffset) throws VerifyCodeSignException, IOException {
        byte[] merkleTreeBytes = new byte[]{};
        int fileReadOffset = readOffset;
        for (SegmentHeader segmentHeader : csb.getSegmentHeaderList()) {
            if (fileReadOffset > segmentHeader.getSegmentOffset()) {
                throw new VerifyCodeSignException("Invaild offset of merkle tree and segment header");
            }
            if (fileReadOffset < segmentHeader.getSegmentOffset()) {
                merkleTreeBytes = new byte[segmentHeader.getSegmentOffset() - fileReadOffset];
                fileReadOffset += signedHap.read(merkleTreeBytes);
            }
            byte[] sh = new byte[segmentHeader.getSegmentSize()];
            fileReadOffset += signedHap.read(sh);
            if (segmentHeader.getType() == 1) {
                csb.setFsVerityInfoSegment(FsVerityInfoSegment.fromByteArray(sh));
                continue;
            }
            if (segmentHeader.getType() == 2) {
                csb.setHapInfoSegment(HapInfoSegment.fromByteArray(sh));
                continue;
            }
            if (segmentHeader.getType() != 3) continue;
            csb.setSoInfoSegment(NativeLibInfoSegment.fromByteArray(sh));
        }
        if (fileReadOffset != csb.getCodeSignBlockHeader().getBlockSize()) {
            throw new VerifyCodeSignException("Invalid blockSize of getCodeSignBlockHeader");
        }
        Extension extension = csb.getHapInfoSegment().getSignInfo().getExtensionByType(1);
        if (extension == null) {
            throw new VerifyCodeSignException("Missing merkleTreeExtension in verifycation");
        }
        if (extension instanceof MerkleTreeExtension) {
            MerkleTreeExtension mte = (MerkleTreeExtension)extension;
            if (computedTreeOffset != mte.getMerkleTreeOffset()) {
                throw new VerifyCodeSignException("Invalid merkle tree offset");
            }
            if ((long)merkleTreeBytes.length != mte.getMerkleTreeSize()) {
                throw new VerifyCodeSignException("Invalid merkle tree size");
            }
            csb.addOneMerkleTree("Hap", merkleTreeBytes);
        }
    }

    private static long getAlignmentAddr(long alignment, long input) {
        long residual = input % alignment;
        if (residual == 0L) {
            return input;
        }
        return input + (alignment - residual);
    }

    public static void verifySingleFile(InputStream input, long length, byte[] signature, long merkleTreeOffset, byte[] inMerkleTreeBytes) throws FsVerityDigestException, CMSException, VerifyCodeSignException {
        Pair<byte[], byte[]> pairResult = null;
        try {
            pairResult = VerifyCodeSignature.generateFsVerityDigest(input, length, merkleTreeOffset);
        }
        catch (PageInfoException e) {
            throw new VerifyCodeSignException(e.getMessage());
        }
        byte[] generatedMerkleTreeBytes = pairResult.getSecond();
        if (generatedMerkleTreeBytes == null) {
            generatedMerkleTreeBytes = new byte[]{};
        }
        if (inMerkleTreeBytes != null && !Arrays.equals(inMerkleTreeBytes, generatedMerkleTreeBytes)) {
            throw new VerifyCodeSignException("verify merkle tree bytes failed");
        }
        CmsUtils.verifySignDataWithUnsignedDataDigest(pairResult.getFirst(), signature);
    }

    private static Pair<byte[], byte[]> generateFsVerityDigest(InputStream inputStream, long size, long merkleTreeOffset) throws FsVerityDigestException, PageInfoException {
        FsVerityGenerator fsVerityGenerator = new FsVerityGenerator();
        fsVerityGenerator.generateFsVerityDigest(inputStream, size, merkleTreeOffset);
        return Pair.create(fsVerityGenerator.getFsVerityDigest(), fsVerityGenerator.getTreeBytes());
    }
}

