/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.hap.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.ohos.hapsigntool.codesigning.exception.CodeSignException;
import com.ohos.hapsigntool.codesigning.exception.ElfFormatException;
import com.ohos.hapsigntool.codesigning.exception.FsVerityDigestException;
import com.ohos.hapsigntool.codesigning.sign.CodeSigning;
import com.ohos.hapsigntool.codesigning.sign.PageInfoGenerator;
import com.ohos.hapsigntool.entity.Options;
import com.ohos.hapsigntool.entity.ParamConstants;
import com.ohos.hapsigntool.entity.SignatureAlgorithm;
import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.HapFormatException;
import com.ohos.hapsigntool.error.InvalidParamsException;
import com.ohos.hapsigntool.error.ProfileException;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.error.SignatureException;
import com.ohos.hapsigntool.error.VerifyCertificateChainException;
import com.ohos.hapsigntool.hap.config.SignerConfig;
import com.ohos.hapsigntool.hap.entity.SigningBlock;
import com.ohos.hapsigntool.hap.sign.SignBin;
import com.ohos.hapsigntool.hap.sign.SignElf;
import com.ohos.hapsigntool.hap.sign.SignHap;
import com.ohos.hapsigntool.hap.utils.HapUtils;
import com.ohos.hapsigntool.hap.verify.VerifyUtils;
import com.ohos.hapsigntool.utils.CertificateUtils;
import com.ohos.hapsigntool.utils.DigestUtils;
import com.ohos.hapsigntool.utils.EscapeCharacter;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.utils.ParamProcessUtil;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.zip.ByteBufferZipDataInput;
import com.ohos.hapsigntool.zip.RandomAccessFileZipDataInput;
import com.ohos.hapsigntool.zip.RandomAccessFileZipDataOutput;
import com.ohos.hapsigntool.zip.Zip;
import com.ohos.hapsigntool.zip.ZipDataInput;
import com.ohos.hapsigntool.zip.ZipFileInfo;
import com.ohos.hapsigntool.zip.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class SignProvider {
    private static final LogUtils LOGGER = new LogUtils(SignProvider.class);
    private static final List<String> VALID_SIGN_ALG_NAME = new ArrayList<String>();
    private static final List<String> PARAMETERS_NEED_ESCAPE = new ArrayList<String>();
    private static final long TIMESTAMP = 1230768000000L;
    private static final int COMPRESSION_MODE = 9;
    protected List<SigningBlock> optionalBlocks = new ArrayList<SigningBlock>();
    protected Map<String, String> signParams = new HashMap<String, String>();
    private String profileContent;

    protected void loadOptionalBlocks() throws InvalidParamsException {
        String property = this.signParams.get("property");
        this.loadOptionalBlock(property, 0x20000003);
        String profile = this.signParams.get("profileFile");
        this.loadOptionalBlock(profile, 0x20000002);
        String proofOfRotation = this.signParams.get("proof");
        this.loadOptionalBlock(proofOfRotation, 0x20000001);
    }

    private void loadOptionalBlock(String file, int type) throws InvalidParamsException {
        if (!this.checkStringIsNotNullAndEmity(file)) {
            return;
        }
        if (!this.checkFile(file)) {
            LOGGER.error("check file failed");
            throw new InvalidParamsException(SignToolErrMsg.PARAM_CHECK_FAILED.toString(file, "Invalid file: " + file + ", filetype: " + type));
        }
        try {
            byte[] optionalBlockBytes = HapUtils.readFileToByte(file);
            if (optionalBlockBytes == null || optionalBlockBytes.length <= 0) {
                LOGGER.warn("Optional block is null!");
                return;
            }
            this.optionalBlocks.add(new SigningBlock(type, optionalBlockBytes));
        }
        catch (IOException e) {
            throw new InvalidParamsException(SignToolErrMsg.FILE_READ_FAILED.toString(file));
        }
    }

    private boolean checkFile(String filePath) {
        if (!this.checkStringIsNotNullAndEmity(filePath)) {
            LOGGER.error("fileName is null");
            return false;
        }
        File file = new File(filePath);
        if (!file.canRead() || !file.isFile()) {
            LOGGER.error(filePath + " not exist or can not read!");
            return false;
        }
        return true;
    }

    private boolean checkStringIsNotNullAndEmity(String str) {
        return str != null && !"".equals(str);
    }

    private List<X509Certificate> getPublicCerts() {
        String publicCertsFile = this.signParams.get("appCertFile");
        if (StringUtils.isEmpty(publicCertsFile)) {
            return Collections.emptyList();
        }
        return this.getCertificateChainFromFile(publicCertsFile);
    }

    public Optional<X509CRL> getCrl() {
        return Optional.empty();
    }

    public SignerConfig createSignerConfigs(List<X509Certificate> certificates, Optional<X509CRL> crl, Options options) {
        SignerConfig signerConfig = new SignerConfig();
        signerConfig.setParameters(this.signParams);
        signerConfig.setCertificates(certificates);
        signerConfig.setOptions(options);
        ArrayList<SignatureAlgorithm> signatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        signatureAlgorithms.add(ParamProcessUtil.getSignatureAlgorithm(this.signParams.get("signAlg")));
        signerConfig.setSignatureAlgorithms(signatureAlgorithms);
        if (!crl.equals(Optional.empty())) {
            signerConfig.setX509CRLs(Collections.singletonList(crl.get()));
        }
        return signerConfig;
    }

    public boolean signBin(Options options) {
        SignerConfig signerConfig;
        List<X509Certificate> publicCert = null;
        try {
            publicCert = this.getX509Certificates(options);
            Optional<X509CRL> crl = this.getCrl();
            signerConfig = this.createSignerConfigs(publicCert, crl, options);
        }
        catch (InvalidParamsException | ProfileException e) {
            LOGGER.error("create signer configs failed.", e);
            this.printErrorLogWithoutStack(e);
            return false;
        }
        if (!SignBin.sign(signerConfig, this.signParams)) {
            LOGGER.error("Sign bin internal failed.");
            return false;
        }
        LOGGER.info("Sign success");
        return true;
    }

    public boolean signElf(Options options) {
        List<X509Certificate> publicCert = null;
        SignerConfig signerConfig = null;
        try {
            publicCert = this.getX509Certificates(options);
            Optional<X509CRL> crl = this.getCrl();
            signerConfig = this.createSignerConfigs(publicCert, crl, options);
        }
        catch (InvalidParamsException | ProfileException e) {
            LOGGER.error("create signer configs failed.", e);
            this.printErrorLogWithoutStack(e);
            return false;
        }
        if (ParamConstants.ProfileSignFlag.DISABLE_SIGN_CODE.getSignFlag().equals(this.signParams.get("profileSigned"))) {
            LOGGER.error("Sign elf can not use unsigned profile.");
            return false;
        }
        if (this.profileContent != null) {
            this.signParams.put("profileContent", this.profileContent);
        }
        if (!SignElf.sign(signerConfig, this.signParams)) {
            LOGGER.error("Sign elf internal failed.");
            return false;
        }
        LOGGER.info("Sign success");
        return true;
    }

    public boolean sign(Options options) {
        List<X509Certificate> publicCerts = null;
        File output = null;
        File tmpOutput = null;
        boolean isRet = false;
        boolean isPathOverlap = false;
        try {
            publicCerts = this.getX509Certificates(options);
            this.checkCompatibleVersion();
            File input = new File(this.signParams.get("inFile"));
            output = new File(this.signParams.get("outFile"));
            String suffix = this.getFileSuffix(input);
            isPathOverlap = input.getCanonicalPath().equals(output.getCanonicalPath());
            tmpOutput = isPathOverlap ? File.createTempFile("signedHap", "." + suffix) : output;
            int alignment = Integer.parseInt(this.signParams.get("a"));
            Zip zip = this.copyFileAndAlignment(input, tmpOutput, alignment, suffix);
            try (RandomAccessFile outputHap = new RandomAccessFile(tmpOutput, "rw");){
                RandomAccessFileZipDataInput outputHapIn = new RandomAccessFileZipDataInput(outputHap);
                ZipFileInfo zipInfo = ZipUtils.findZipInfo(outputHapIn);
                long centralDirectoryOffset = zipInfo.getCentralDirectoryOffset();
                ZipDataInput beforeCentralDir = outputHapIn.slice(0L, centralDirectoryOffset);
                ByteBuffer centralDirBuffer = outputHapIn.createByteBuffer(centralDirectoryOffset, zipInfo.getCentralDirectorySize());
                ByteBufferZipDataInput centralDirectory = new ByteBufferZipDataInput(centralDirBuffer);
                ByteBuffer eocdBuffer = zipInfo.getEocd();
                ByteBufferZipDataInput eocd = new ByteBufferZipDataInput(eocdBuffer);
                Optional<X509CRL> crl = this.getCrl();
                SignerConfig signerConfig = this.createSignerConfigs(publicCerts, crl, options);
                signerConfig.setCompatibleVersion(Integer.parseInt(this.signParams.get("compatibleVersion")));
                ZipDataInput[] contents = new ZipDataInput[]{beforeCentralDir, centralDirectory, eocd};
                this.appendCodeSignBlock(signerConfig, tmpOutput, suffix, centralDirectoryOffset, zip);
                byte[] signingBlock = SignHap.sign(contents, signerConfig, this.optionalBlocks);
                long newCentralDirectoryOffset = centralDirectoryOffset + (long)signingBlock.length;
                ZipUtils.setCentralDirectoryOffset(eocdBuffer, newCentralDirectoryOffset);
                LOGGER.info("Generate signing block success, begin write it to output file");
                this.outputSignedFile(outputHap, centralDirectoryOffset, signingBlock, centralDirectory, eocdBuffer);
                isRet = true;
            }
        }
        catch (CodeSignException | ElfFormatException | FsVerityDigestException | CustomException | HapFormatException | InvalidParamsException | ProfileException e) {
            this.printErrorLogWithoutStack(e);
        }
        catch (IOException e) {
            LOGGER.error(SignToolErrMsg.FILE_IO_FAILED.toString(e.getMessage()));
        }
        catch (SignatureException e) {
            this.printErrorLog(e);
        }
        return this.doAfterSign(isRet, isPathOverlap, tmpOutput, output);
    }

    private void appendCodeSignBlock(SignerConfig signerConfig, File tmpOutput, String suffix, long centralDirectoryOffset, Zip zip) throws FsVerityDigestException, CodeSignException, IOException, HapFormatException, ProfileException {
        if (this.signParams.get("signCode").equals(ParamConstants.SignCodeFlag.ENABLE_SIGN_CODE.getSignCodeFlag())) {
            if (!StringUtils.containsIgnoreCase(CodeSigning.SUPPORT_FILE_FORM, suffix)) {
                LOGGER.info("no need to sign code for :" + suffix);
                return;
            }
            long codeSignOffset = centralDirectoryOffset + (long)(12 * (this.optionalBlocks.size() + 2) + 12);
            CodeSigning codeSigning = new CodeSigning(signerConfig);
            byte[] codeSignArray = codeSigning.getCodeSignBlock(tmpOutput, codeSignOffset, suffix, this.profileContent, zip);
            ByteBuffer result = ByteBuffer.allocate(codeSignArray.length + 12);
            result.order(ByteOrder.LITTLE_ENDIAN);
            result.putInt(0x30000001);
            result.putInt(codeSignArray.length);
            result.putInt((int)codeSignOffset);
            result.put(codeSignArray);
            SigningBlock propertyBlock = new SigningBlock(0x20000003, result.array());
            this.optionalBlocks.add(0, propertyBlock);
        }
    }

    private String getFileSuffix(File output) throws HapFormatException {
        String[] fileNameArray = output.getName().split("\\.");
        if (fileNameArray.length < 2) {
            throw new HapFormatException(SignToolErrMsg.ZIP_FORMAT_FAILED.toString("suffix format error" + output));
        }
        return fileNameArray[fileNameArray.length - 1];
    }

    private List<X509Certificate> getX509Certificates(Options options) throws InvalidParamsException, ProfileException {
        this.checkParams(options);
        List<X509Certificate> publicCerts = this.getPublicCerts();
        this.loadOptionalBlocks();
        if ("elf".equals(options.getString("inForm")) && StringUtils.isEmpty(options.getString("profileFile"))) {
            return publicCerts;
        }
        this.checkProfileValid(publicCerts);
        return publicCerts;
    }

    private void outputSignedFile(RandomAccessFile outputHap, long centralDirectoryOffset, byte[] signingBlock, ZipDataInput centralDirectory, ByteBuffer eocdBuffer) throws IOException {
        RandomAccessFileZipDataOutput outputHapOut = new RandomAccessFileZipDataOutput(outputHap, centralDirectoryOffset);
        outputHapOut.write(signingBlock, 0, signingBlock.length);
        centralDirectory.copyTo(0L, centralDirectory.size(), outputHapOut);
        outputHapOut.write(eocdBuffer);
    }

    private boolean doAfterSign(boolean isSuccess, boolean isPathOverlap, File tmpOutput, File output) {
        boolean isRet = isSuccess;
        if (isRet && isPathOverlap) {
            try {
                Files.move(tmpOutput.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.printErrorLog(e);
                isRet = false;
            }
        }
        if (isRet) {
            LOGGER.info("Sign Hap success!");
        } else {
            FileUtils.deleteFile(tmpOutput);
        }
        return isRet;
    }

    private void printErrorLog(Exception exception) {
        if (exception != null) {
            LOGGER.error(exception.getMessage(), exception);
        }
    }

    private void printErrorLogWithoutStack(Exception exception) {
        if (exception != null) {
            LOGGER.error(exception.getMessage());
        }
    }

    private Zip copyFileAndAlignment(File input, File tmpOutput, int alignment, String suffix) throws IOException, HapFormatException, ElfFormatException {
        PageInfoGenerator pageInfoGenerator;
        byte[] bitMap;
        Zip zip = new Zip(input);
        zip.alignment(alignment);
        if (StringUtils.containsIgnoreCase(CodeSigning.SUPPORT_FILE_FORM, suffix) && ParamConstants.SignCodeFlag.ENABLE_SIGN_CODE.getSignCodeFlag().equals(this.signParams.get("signCode")) && (bitMap = (pageInfoGenerator = new PageInfoGenerator(zip)).generateBitMap()) != null && bitMap.length > 0) {
            zip.addBitMap(bitMap);
            zip.alignment(alignment);
        }
        zip.removeSignBlock();
        long start = System.currentTimeMillis();
        zip.toFile(tmpOutput.getCanonicalPath());
        long end = System.currentTimeMillis();
        LOGGER.debug("zip to file use {} ms", end - start);
        return zip;
    }

    private void checkSignatureAlg() throws InvalidParamsException {
        String signAlg = this.signParams.get("signAlg").trim();
        for (String validAlg : VALID_SIGN_ALG_NAME) {
            if (!validAlg.equalsIgnoreCase(signAlg)) continue;
            return;
        }
        LOGGER.error("Unsupported signature algorithm :" + signAlg);
        throw new InvalidParamsException(SignToolErrMsg.PARAM_CHECK_FAILED.toString("signAlg", "Invalid parameter: Sign Alg"));
    }

    protected void checkSignAlignment() {
        if (!this.signParams.containsKey("a")) {
            this.signParams.put("a", "4");
        }
    }

    private X509Certificate getDevelopmentCertificate(JsonObject buildInfoObject) {
        String developmentCertElememt = "development-certificate";
        String developmentCertificate = buildInfoObject.get("development-certificate").getAsString();
        return DigestUtils.decodeBase64ToX509Certifate(developmentCertificate);
    }

    private X509Certificate getReleaseCertificate(JsonObject buildInfoObject) {
        String distributeCertElememt = "distribution-certificate";
        String distributeCertificate = buildInfoObject.get("distribution-certificate").getAsString();
        return DigestUtils.decodeBase64ToX509Certifate(distributeCertificate);
    }

    private String getCertificateCN(X509Certificate cert) {
        if (cert == null) {
            return "";
        }
        String nameStr = cert.getSubjectX500Principal().getName();
        X500Name name = new X500Name(nameStr);
        RDN[] commonName = name.getRDNs(BCStyle.CN);
        if (commonName.length <= 0) {
            CustomException.throwException(ERROR.CERTIFICATE_ERROR, SignToolErrMsg.CERTIFICATE_ERROR.toString("subject without common name"));
        }
        return commonName[0].getFirst().getValue().toString();
    }

    private byte[] findProfileFromOptionalBlocks() {
        byte[] profile = new byte[]{};
        for (SigningBlock optionalBlock : this.optionalBlocks) {
            if (optionalBlock.getType() != 0x20000002) continue;
            profile = optionalBlock.getValue();
        }
        return profile;
    }

    private void checkProfileValid(List<X509Certificate> inputCerts) throws ProfileException {
        try {
            byte[] profile = this.findProfileFromOptionalBlocks();
            boolean isProfileWithoutSign = ParamConstants.ProfileSignFlag.DISABLE_SIGN_CODE.getSignFlag().equals(this.signParams.get("profileSigned"));
            if (!isProfileWithoutSign) {
                CMSSignedData cmsSignedData = new CMSSignedData(profile);
                boolean isVerify = VerifyUtils.verifyCmsSignedData(cmsSignedData);
                if (!isVerify) {
                    throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_INVALID.toString());
                }
                Object contentObj = cmsSignedData.getSignedContent().getContent();
                if (!(contentObj instanceof byte[])) {
                    throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_FAILED.toString("Check profile failed, signed profile content is not byte array!"));
                }
                this.profileContent = new String((byte[])contentObj, StandardCharsets.UTF_8);
            } else {
                this.profileContent = new String(profile, StandardCharsets.UTF_8);
            }
            JsonElement parser = JsonParser.parseString(this.profileContent);
            JsonObject profileJson = parser.getAsJsonObject();
            this.checkProfileInfo(profileJson, inputCerts);
        }
        catch (CMSException e) {
            throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_INVALID.toString());
        }
        catch (JsonParseException e) {
            throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_FAILED.toString("Invalid parameter: profile content is not a JSON.", e));
        }
    }

    private void checkProfileInfo(JsonObject profileJson, List<X509Certificate> inputCerts) throws ProfileException {
        X509Certificate certInProfile;
        String profileTypeKey = "type";
        String profileType = profileJson.get(profileTypeKey).getAsString();
        if (profileType == null || profileType.length() == 0) {
            throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_FAILED.toString("Get profile type error!"));
        }
        String buildInfoMember = "bundle-info";
        JsonObject buildInfoObject = profileJson.getAsJsonObject(buildInfoMember);
        if (profileType.equalsIgnoreCase("release")) {
            certInProfile = this.getReleaseCertificate(buildInfoObject);
        } else if (profileType.equalsIgnoreCase("debug")) {
            certInProfile = this.getDevelopmentCertificate(buildInfoObject);
        } else {
            throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_FAILED.toString("Unsupported profile type!"));
        }
        if (!inputCerts.isEmpty() && !this.checkInputCertMatchWithProfile(inputCerts.get(0), certInProfile)) {
            throw new ProfileException(SignToolErrMsg.PROFILE_CERT_MATCH_FAILED.toString());
        }
        String cn = this.getCertificateCN(certInProfile);
        LOGGER.info("certificate in profile: {}", cn);
        if (cn.isEmpty()) {
            throw new ProfileException(SignToolErrMsg.VERIFY_PROFILE_FAILED.toString("Common name of certificate is empty!"));
        }
    }

    protected boolean checkInputCertMatchWithProfile(X509Certificate inputCert, X509Certificate certInProfile) {
        return true;
    }

    public void checkParams(Options options) throws InvalidParamsException {
        String[] paramFileds = new String[]{"a", "signAlg", "inFile", "outFile", "keyAlias", "profileFile", "proof", "property", "signServer", "profileSigned", "appCertFile", "compatibleVersion", "signCode", "inForm"};
        Set<String> paramSet = ParamProcessUtil.initParamField(paramFileds);
        for (String paramKey : options.keySet()) {
            if (!paramSet.contains(paramKey)) continue;
            this.signParams.put(paramKey, this.getParamValue(paramKey, options.getString(paramKey)));
        }
        if (!this.signParams.containsKey("profileSigned")) {
            this.signParams.put("profileSigned", "1");
        }
        if (StringUtils.isEmpty(this.signParams.get("profileSigned"))) {
            this.signParams.put("profileSigned", "1");
        }
        this.checkSignCode();
        this.checkSignatureAlg();
        this.checkSignAlignment();
    }

    protected void checkSignCode() throws InvalidParamsException {
        if (!this.signParams.containsKey("signCode")) {
            this.signParams.put("signCode", ParamConstants.SignCodeFlag.ENABLE_SIGN_CODE.getSignCodeFlag());
            return;
        }
        String codeSign = this.signParams.get("signCode");
        if (!codeSign.equals(ParamConstants.SignCodeFlag.ENABLE_SIGN_CODE.getSignCodeFlag()) && !codeSign.equals(ParamConstants.SignCodeFlag.DISABLE_SIGN_CODE.getSignCodeFlag())) {
            throw new InvalidParamsException(SignToolErrMsg.PARAM_CHECK_FAILED.toString("signCode", "Invalid parameter"));
        }
    }

    protected void checkCompatibleVersion() throws InvalidParamsException {
        if (!this.signParams.containsKey("compatibleVersion")) {
            this.signParams.put("compatibleVersion", "9");
            return;
        }
        String compatibleApiVersionVal = this.signParams.get("compatibleVersion");
        try {
            int n = Integer.parseInt(compatibleApiVersionVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidParamsException(SignToolErrMsg.PARAM_CHECK_FAILED.toString("compatibleVersion", "Invalid parameter"));
        }
    }

    protected String getParamValue(String paramName, String paramValue) {
        for (String name : PARAMETERS_NEED_ESCAPE) {
            if (!name.equals(paramName)) continue;
            return EscapeCharacter.unescape(paramValue);
        }
        return paramValue;
    }

    private List<X509Certificate> getCertificateChainFromFile(String certChianFile) {
        try {
            return CertificateUtils.getCertListFromFile(certChianFile);
        }
        catch (CertificateException e) {
            LOGGER.error("File content is not certificates! " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("Certificate file exception: " + e.getMessage());
        }
        catch (VerifyCertificateChainException e) {
            LOGGER.error(e.getMessage());
        }
        return Collections.emptyList();
    }

    static {
        VALID_SIGN_ALG_NAME.add("SHA256withECDSA");
        VALID_SIGN_ALG_NAME.add("SHA384withECDSA");
        VALID_SIGN_ALG_NAME.add("SHA512withECDSA");
        VALID_SIGN_ALG_NAME.add("SHA256withRSA/PSS");
        VALID_SIGN_ALG_NAME.add("SHA384withRSA/PSS");
        VALID_SIGN_ALG_NAME.add("SHA512withRSA/PSS");
        VALID_SIGN_ALG_NAME.add("SHA256withRSAANDMGF1");
        VALID_SIGN_ALG_NAME.add("SHA384withRSAANDMGF1");
        VALID_SIGN_ALG_NAME.add("SHA512withRSAANDMGF1");
        Security.addProvider(new BouncyCastleProvider());
        PARAMETERS_NEED_ESCAPE.add("password");
        PARAMETERS_NEED_ESCAPE.add("keystorePwd");
        PARAMETERS_NEED_ESCAPE.add("keyPwd");
    }
}

