/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.error.ZipException;
import com.ohos.hapsigntool.zip.UnsignedDecimalUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class ZipEntryHeader {
    public static final int HEADER_LENGTH = 30;
    public static final int SIGNATURE = 67324752;
    private short version;
    private short flag;
    private short method;
    private short lastTime;
    private short lastDate;
    private int crc32;
    private long compressedSize;
    private long unCompressedSize;
    private int fileNameLength;
    private int extraLength;
    private String fileName;
    private byte[] extraData;
    private int length;

    public void updateLength() {
        this.length = 30 + this.fileNameLength + this.extraLength;
    }

    public static ZipEntryHeader getZipEntryHeader(byte[] bytes) throws ZipException {
        ZipEntryHeader entryHeader = new ZipEntryHeader();
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        if (bf.getInt() != 67324752) {
            throw new ZipException("find zip entry head failed");
        }
        entryHeader.setVersion(bf.getShort());
        entryHeader.setFlag(bf.getShort());
        entryHeader.setMethod(bf.getShort());
        entryHeader.setLastTime(bf.getShort());
        entryHeader.setLastDate(bf.getShort());
        entryHeader.setCrc32(bf.getInt());
        entryHeader.setCompressedSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        entryHeader.setUnCompressedSize(UnsignedDecimalUtil.getUnsignedInt(bf));
        entryHeader.setFileNameLength(UnsignedDecimalUtil.getUnsignedShort(bf));
        entryHeader.setExtraLength(UnsignedDecimalUtil.getUnsignedShort(bf));
        entryHeader.updateLength();
        return entryHeader;
    }

    public void readFileName(byte[] bytes) {
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        if (this.fileNameLength > 0) {
            byte[] nameBytes = new byte[this.fileNameLength];
            bf.get(nameBytes);
            this.fileName = new String(nameBytes, StandardCharsets.UTF_8);
        }
    }

    public void readExtra(byte[] bytes) {
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        if (this.extraLength > 0) {
            byte[] extra = new byte[this.extraLength];
            bf.get(extra);
            this.extraData = extra;
        }
    }

    public byte[] toBytes() {
        ByteBuffer bf = ByteBuffer.allocate(this.length).order(ByteOrder.LITTLE_ENDIAN);
        bf.putInt(67324752);
        bf.putShort(this.version);
        bf.putShort(this.flag);
        bf.putShort(this.method);
        bf.putShort(this.lastTime);
        bf.putShort(this.lastDate);
        bf.putInt(this.crc32);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.compressedSize);
        UnsignedDecimalUtil.setUnsignedInt(bf, this.unCompressedSize);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.fileNameLength);
        UnsignedDecimalUtil.setUnsignedShort(bf, this.extraLength);
        if (this.fileNameLength > 0) {
            bf.put(this.fileName.getBytes(StandardCharsets.UTF_8));
        }
        if (this.extraLength > 0) {
            bf.put(this.extraData);
        }
        return bf.array();
    }

    public static int getHeaderLength() {
        return 30;
    }

    public static int getSIGNATURE() {
        return 67324752;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getFlag() {
        return this.flag;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public short getMethod() {
        return this.method;
    }

    public void setMethod(short method) {
        this.method = method;
    }

    public short getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(short lastTime) {
        this.lastTime = lastTime;
    }

    public short getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(short lastDate) {
        this.lastDate = lastDate;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    public long getUnCompressedSize() {
        return this.unCompressedSize;
    }

    public void setUnCompressedSize(long unCompressedSize) {
        this.unCompressedSize = unCompressedSize;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
    }

    public int getExtraLength() {
        return this.extraLength;
    }

    public void setExtraLength(int extraLength) {
        this.extraLength = extraLength;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public void setExtraData(byte[] extraData) {
        this.extraData = extraData;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

