/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntoolcmd;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.utils.StringUtils;
import com.ohos.hapsigntool.utils.ValidateUtils;
import com.ohos.hapsigntoolcmd.Params;
import com.ohos.hapsigntoolcmd.ParamsTrustlist;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public final class CmdUtil {
    private static final int ARGS_MIN_LEN = 2;
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d{1,10}");

    private CmdUtil() {
    }

    public static Params convert2Params(String[] args) {
        ValidateUtils.throwIfNotMatches(args.length >= 2, ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_NUM_ERROR.toString());
        Params params = new Params();
        String method = args[0];
        params.setMethod(method);
        String keyStandBy = null;
        boolean readKey = true;
        List<String> trustList = ParamsTrustlist.getTrustList(method);
        if (trustList.isEmpty()) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.UNSUPPORTED_METHOD.toString(method));
        }
        for (int i = 1; i < args.length; ++i) {
            String value = args[i];
            if (StringUtils.isEmpty(value)) {
                CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_VALUE_EMPTY.toString("first param"));
            }
            if (readKey) {
                if (value.startsWith("-")) {
                    value = value.equals("-signcode") ? "-signCode" : value;
                    boolean isTrust = trustList.contains(value);
                    ValidateUtils.throwIfNotMatches(isTrust, ERROR.COMMAND_PARAM_ERROR, SignToolErrMsg.PARAM_NOT_TRUSTED.toString());
                    keyStandBy = value.substring(1);
                    readKey = false;
                    continue;
                }
                CustomException.throwException(ERROR.COMMAND_PARAM_ERROR, SignToolErrMsg.PARAM_NOT_IN_PAIRS.toString());
                continue;
            }
            boolean success = CmdUtil.validAndPutParam(params, keyStandBy, value);
            if (!success) continue;
            keyStandBy = null;
            readKey = true;
        }
        return params;
    }

    private static boolean validAndPutParam(Params params, String key, String value) {
        boolean result;
        if (StringUtils.isEmpty(key)) {
            result = false;
        } else if (StringUtils.isEmpty(value)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_VALUE_EMPTY.toString(key));
            result = false;
        } else if (params.getOptions().containsKey(key)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_DUPLICATE.toString(key));
            result = false;
        } else if (key.toLowerCase(Locale.ROOT).endsWith("pwd")) {
            params.getOptions().put(key, value.toCharArray());
            result = true;
        } else {
            params.getOptions().put(key, value);
            result = true;
        }
        return result;
    }

    public static void judgeAlgType(String alg) {
        if (!"RSA".equalsIgnoreCase(alg) && !"ECC".equalsIgnoreCase(alg)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("keyAlg", "Key algorithm only allowed to be ECC or RSA."));
        }
    }

    public static void judgeSize(String size, String alg) {
        String[] array = new String[]{"2048", "3072", "4096", "NIST-P-256", "NIST-P-384"};
        List<String> arrayList = Arrays.asList(array);
        if (!arrayList.contains(size)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("KeySize", "Key size include in set of " + arrayList));
        }
        if ("RSA".equalsIgnoreCase(alg)) {
            if (!("2048".equals(size) || "3072".equals(size) || "4096".equals(size))) {
                CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("KeySize", "Key size of RSA include in set of {2048, 3072, 4096}"));
            }
        } else if (!"NIST-P-256".equalsIgnoreCase(size) && !"NIST-P-384".equalsIgnoreCase(size)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("KeySize", "Key size include in set of " + arrayList));
        }
    }

    public static void judgeSignAlgType(String signAlg) {
        List<String> arrayList = Arrays.asList("SHA256withRSA", "SHA384withRSA", "SHA256withECDSA", "SHA384withECDSA");
        if (!arrayList.contains(signAlg)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("SignAlg", "signature algorithms include " + arrayList));
        }
    }

    public static void judgeEndSignAlgType(String signAlg) {
        List<String> arrayList = Arrays.asList("SHA256withECDSA", "SHA384withECDSA");
        if (!arrayList.contains(signAlg)) {
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("SignAlg", "signature algorithms include SHA256withECDSA,SHA384withECDSA"));
        }
    }

    public static void verifyType(String inputType, String supportTypes) {
        String[] types = inputType.split(",");
        List<String> supportList = Arrays.asList(supportTypes.split(","));
        for (String type : types) {
            if (StringUtils.isEmpty(type) || supportList.contains(type.trim())) continue;
            CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_NOT_TRUSTED.toString(inputType));
        }
    }

    public static String convertAlgSize(String size) {
        if (size.startsWith("NIST-P-")) {
            return size.replace("NIST-P-", "");
        }
        if (INTEGER_PATTERN.matcher(size).matches()) {
            return size;
        }
        CustomException.throwException(ERROR.COMMAND_ERROR, SignToolErrMsg.PARAM_CHECK_FAILED.toString("KeySize", "Key size is incorrect"));
        return size;
    }

    public static final class Method {
        public static final String GENERATE_APP_CERT = "generate-app-cert";
        public static final String GENERATE_CA = "generate-ca";
        public static final String GENERATE_CERT = "generate-cert";
        public static final String GENERATE_CSR = "generate-csr";
        public static final String GENERATE_KEYPAIR = "generate-keypair";
        public static final String GENERATE_PROFILE_CERT = "generate-profile-cert";
        public static final String SIGN_APP = "sign-app";
        public static final String SIGN_PROFILE = "sign-profile";
        public static final String VERIFY_APP = "verify-app";
        public static final String VERIFY_PROFILE = "verify-profile";
    }
}

