/*
 * Decompiled with CFR 0.152.
 */
package ohos;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import ohos.BundleException;
import ohos.FileUtils;
import ohos.HQFInfo;
import ohos.HQFVerify;
import ohos.HapVerify;
import ohos.HapVerifyInfo;
import ohos.Log;
import ohos.ModuleJsonUtil;
import ohos.PackageNormalize;
import ohos.PackageUtil;
import ohos.Utility;
import org.apache.commons.compress.archivers.zip.DefaultBackingStoreSupplier;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;

public class Compressor {
    private static final String HAP_SUFFIX = ".hap";
    private static final String HSP_SUFFIX = ".hsp";
    private static final String PNG_SUFFIX = ".png";
    private static final String UPPERCASE_PNG_SUFFIX = ".PNG";
    private static final String CONFIG_JSON = "config.json";
    private static final String MODULE_JSON = "module.json";
    private static final String PATCH_JSON = "patch.json";
    private static final String ADDITION_JSON = "addition.json";
    private static final String PKG_CONTEXT_INFO = "pkgContextInfo.json";
    private static final String NAME = "name";
    private static final String NULL_DIR_NAME = "";
    private static final String RES_DIR_NAME = "res/";
    private static final String RESOURCES_DIR_NAME = "resources/";
    private static final String LIBS_DIR_NAME = "libs/";
    private static final String AN_DIR_NAME = "an/";
    private static final String AP_PATH_NAME = "ap/";
    private static final String ASSETS_DIR_NAME = "assets/";
    private static final String SO_DIR_NAME = "maple/";
    private static final String SO_ARM64_DIR_NAME = "maple/arm64/";
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String DISTRO = "distro";
    private static final String FORMS = "forms";
    private static final String MODULE_NAME = "module-name";
    private static final String MODULE_NAME_NEW = "moduleName";
    private static final String JSON_END = "}";
    private static final String SEMICOLON = "\"";
    private static final String COMPRESS_NATIVE_LIBS = "compressNativeLibs";
    private static final String SHARED_LIBS_DIR_NAME = "shared_libs/";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String DEVICE_TYPE_FITNESSWATCH = "fitnessWatch";
    private static final String DEVICE_TYPE_FITNESSWATCH_NEW = "liteWearable";
    private static final String ENTRYCARD_NAME = "EntryCard/";
    private static final String PACKINFO_NAME = "pack.info";
    private static final String ENTRYCARD_BASE_NAME = "base";
    private static final String ENTRYCARD_SNAPSHOT_NAME = "snapshot";
    private static final String PIC_1X2 = "1x2";
    private static final String PIC_2X2 = "2x2";
    private static final String PIC_2X4 = "2x4";
    private static final String PIC_4X4 = "4x4";
    private static final String PIC_1X1 = "1x1";
    private static final String PIC_6X4 = "6x4";
    private static final String REGEX_LANGUAGE = "^[a-z]{2}$";
    private static final String REGEX_SCRIPT = "^[A-Z][a-z]{3}$";
    private static final String REGEX_COUNTRY = "^[A-Z]{2,3}|[0-9]{3}$";
    private static final String REGEX_ORIENTATION = "^vertical|horizontal$";
    private static final String REGEX_DEVICE_TYPE = "^phone|tablet|car|tv|wearable|liteWearable|2in1$";
    private static final String REGEX_SCREEN_DENSITY = "^sdpi|mdpi|ldpi|xldpi|xxldpi$";
    private static final String REGEX_COLOR_MODE = "^light|dark$";
    private static final String REGEX_SHAPE = "^circle$";
    private static final String JS_PATH = "js/";
    private static final String ETS_PATH = "ets/";
    private static final String HNP_PATH = "hnp/";
    private static final String TEMP_HAP_DIR = "tempHapDir";
    private static final String TEMP_HSP_DIR = "tempHspDir";
    private static final String TEMP_SELECTED_HAP_DIR = "tempSelectedHapDir";
    private static final String EMPTY_STRING = "";
    private static final String RELEASE = "Release";
    private static final String TYPE_SHARED = "shared";
    private static final String APP = "app";
    private static final String MODULE = "module";
    private static final String GENERATE_BUILD_HASH = "generateBuildHash";
    private static final String BUILD_HASH = "buildHash";
    private static final String TEMP_DIR = "temp";
    private static final String SHA_256 = "SHA-256";
    private static final String JSON_SUFFIX = ".json";
    private static final String ATOMIC_SERVICE = "atomicService";
    private static final String RAW_FILE_PATH = "resources/rawfile";
    private static final String RES_FILE_PATH = "resources/resfile";
    private static final String SUMMARY = "summary";
    private static final String VERSION_CODE = "versionCode";
    private static final String VERSION_NAME = "versionName";
    private static final String VERSION = "version";
    private static final String CODE = "code";
    private static final String VERSION_RECORD = "version_record.json";
    private static final String RES_INDEX = "resources.index";
    private static final String ETS_FILE_NAME = "ets";
    private static final String HNP_FILE_NAME = "hnp";
    private static final String DIR_FILE_NAME = "dir";
    private static final String AN_FILE_NAME = "an";
    private static final String AP_FILE_NAME = "ap";
    private static final String RESOURCE_FILE_NAME = "resources";
    private static final String JS_FILE_NAME = "js";
    private static final String ASSETS_FILE_NAME = "assets";
    private static final String MAPLE_FILE_NAME = "maple";
    private static final String SHARED_LIBS_FILE_NAME = "shared_libs";
    private static final String LIBS_DIR = "libs";
    private static final String RPCID = "rpcid.sc";
    private static final String HAPADDITION_FOLDER_NAME = "hapAddition";
    private static final String TARGET_FILE_PATH = "hapAddition/resources/base/profile";
    private static final String BACKUP_PREFIX = "backup";
    private static final int ENTRY_FILE_LIMIT_DEFAULT = 2;
    private static final int NOT_ENTRY_FILE_LIMIT_DEFAULT = 2;
    private static final int TOTAL_FILE_LIMIT_DEFAULT = 10;
    private static final int FILE_LIMIT = 10;
    private static final int SHA256_BASE = 255;
    private static final int SHA256_OFFSET = 256;
    private static final int RADIX = 16;
    private static final int BEGIN_INDEX = 1;
    private static final int BUFFER_BYTE_SIZE = 1024;
    private static final int BUFFER_WRITE_SIZE = 1444;
    private static final int BUFFER_SIZE = 40960;
    private static final Log LOG = new Log(Compressor.class.toString());
    private static final int SHARED_APP_HSP_LIMIT = 1;
    private static int entryModuleSizeLimit = 2;
    private static int notEntryModuleSizeLimit = 2;
    private static int sumModuleSizeLimit = 10;
    private static final int INVALID_VERSION = -1;
    private static boolean isOverlay = false;
    private ZipArchiveOutputStream zipOut = null;
    private boolean mIsContain2x2EntryCard = true;
    private boolean isEntryOpen = false;
    private List<String> list = new ArrayList<String>();
    private List<String> formNamesList = new ArrayList<String>();
    private List<String> fileNameList = new ArrayList<String>();
    private List<String> supportDimensionsList = Arrays.asList("1x2", "2x2", "2x4", "4x4", "1x1", "6x4");
    private HashMap<String, HapVerifyInfo> hapVerifyInfoMap = new HashMap();

    public static int getEntryModuleSizeLimit() {
        return entryModuleSizeLimit;
    }

    public static void setEntryModuleSizeLimit(int n) {
        entryModuleSizeLimit = n;
    }

    public static int getNotEntryModuleSizeLimit() {
        return notEntryModuleSizeLimit;
    }

    public static void setNotEntryModuleSizeLimit(int n) {
        notEntryModuleSizeLimit = n;
    }

    public static int getSumModuleSizeLimit() {
        return sumModuleSizeLimit;
    }

    public static void setSumModuleSizeLimit(int n) {
        sumModuleSizeLimit = n;
    }

    public void parseFileSizeLimit(Utility utility) throws BundleException {
        int n = 10;
        String string = utility.getTotalLimit();
        if (!string.isEmpty()) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("parseFileSizeLimit failed, input total-limit invalid.");
                throw new BundleException("parseFileSizeLimit failed, input total-limit invalid.");
            }
            if (n <= 0 || n > 10) {
                LOG.error("parseFileSizeLimit failed, input total-limit invalid.");
                throw new BundleException("parseFileSizeLimit failed, input total-limit invalid.");
            }
        }
        String string2 = utility.getNormalModuleLimit();
        int n2 = 2;
        if (!string2.isEmpty()) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("parseFileSizeLimit failed, input normal-module-limit invalid.");
                throw new BundleException("parseFileSizeLimit failed, input normal-module-limit invalid.");
            }
            if (n2 <= 0 || n2 > n || n2 > 10) {
                LOG.error("parseFileSizeLimit failed, input normal-module-limit invalid.");
                throw new BundleException("parseFileSizeLimit failed, input normal-module-limit invalid.");
            }
        }
        String string3 = utility.getMainModuleLimit();
        int n3 = 2;
        if (!string3.isEmpty()) {
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("parseFileSizeLimit failed, input main-module-limit invalid.");
                throw new BundleException("parseFileSizeLimit failed, input main-module-limit invalid.");
            }
            if (n3 <= 0 || n3 > n || n3 > 10) {
                LOG.error("parseFileSizeLimit failed, input main-module-limit invalid.");
                throw new BundleException("parseFileSizeLimit failed, input main-module-limit invalid.");
            }
        }
        Compressor.setEntryModuleSizeLimit(n3);
        Compressor.setNotEntryModuleSizeLimit(n2);
        Compressor.setSumModuleSizeLimit(n);
    }

    private static boolean isModuleJSON(String string) {
        File file = new File(string);
        return file.isFile() && MODULE_JSON.equals(file.getName());
    }

    public boolean compressProcess(Utility utility) {
        switch (utility.getMode()) {
            case "versionNormalize": {
                this.versionNormalize(utility);
                return true;
            }
            case "hapAddition": {
                this.hapAddition(utility);
                return true;
            }
            case "packageNormalize": {
                return PackageNormalize.normalize(utility);
            }
        }
        return this.defaultProcess(utility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean defaultProcess(Utility utility) {
        File file = new File(utility.getOutPath());
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            LOG.error("Compressor::compressProcess create out file parent directory failed.");
            return false;
        }
        boolean bl = true;
        FileOutputStream fileOutputStream = null;
        CheckedOutputStream checkedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            checkedOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            this.zipOut = new ZipArchiveOutputStream(checkedOutputStream);
            this.zipOut.setLevel(utility.getCompressLevel());
            this.compressExcute(utility);
            this.closeZipOutputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
            LOG.error("Compressor::compressProcess file not found exception: " + fileNotFoundException.getMessage());
            this.closeZipOutputStream();
            Utility.closeStream(this.zipOut);
            Utility.closeStream(checkedOutputStream);
            Utility.closeStream(fileOutputStream);
        }
        catch (BundleException bundleException) {
            bl = false;
            LOG.error("Compressor::compressProcess Bundle exception: " + bundleException.getMessage());
            this.closeZipOutputStream();
            {
                catch (Throwable throwable) {
                    this.closeZipOutputStream();
                    Utility.closeStream(this.zipOut);
                    Utility.closeStream(checkedOutputStream);
                    Utility.closeStream(fileOutputStream);
                    throw throwable;
                }
            }
            Utility.closeStream(this.zipOut);
            Utility.closeStream(checkedOutputStream);
            Utility.closeStream(fileOutputStream);
        }
        Utility.closeStream(this.zipOut);
        Utility.closeStream(checkedOutputStream);
        Utility.closeStream(fileOutputStream);
        if (bl && !this.checkAppAtomicServiceCompressedSizeValid(utility)) {
            bl = false;
            LOG.error("Compressor::compressProcess check atomic service size fail.");
        }
        if (!bl) {
            LOG.error("Compressor::compressProcess compress failed.");
            if (!file.delete()) {
                LOG.error("Compressor::compressProcess delete dest file failed.");
            }
        }
        return bl;
    }

    private void compressExcute(Utility utility) throws BundleException {
        switch (utility.getMode()) {
            case "hap": {
                this.compressHap(utility);
                break;
            }
            case "har": {
                this.compressHarMode(utility);
                break;
            }
            case "app": {
                this.compressAppMode(utility);
                break;
            }
            case "fastApp": {
                this.compressFastAppMode(utility);
                break;
            }
            case "multiApp": {
                this.compressAppModeForMultiProject(utility);
                break;
            }
            case "hqf": {
                this.compressHQFMode(utility);
                break;
            }
            case "appqf": {
                this.compressAPPQFMode(utility);
                break;
            }
            case "hsp": {
                this.compressHsp(utility);
                break;
            }
            default: {
                this.compressPackResMode(utility);
            }
        }
    }

    private void compressHsp(Utility utility) throws BundleException {
        Compressor.setGenerateBuildHash(utility);
        if (Compressor.isModuleJSON(utility.getJsonPath())) {
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            String string = optional.get();
            if (!Compressor.checkStageAsanTsanEnabledValid(string)) {
                LOG.error("checkStageAsanTsanEnabledValid failed.");
                throw new BundleException("compressHsp failed.");
            }
            if (!Compressor.checkStageHwasanEnabledValid(string)) {
                LOG.error("checkStageHwasanEnabledValid failed.");
                throw new BundleException("compressHsp failed.");
            }
            if (!Compressor.checkStageUbsanEnabledValid(string)) {
                LOG.error("checkStageUbsanEnabledValid failed.");
                throw new BundleException("compressHsp failed.");
            }
            if (!Compressor.checkStageAtomicService(string)) {
                LOG.error("checkStageAtomicService failed.");
                throw new BundleException("checkStageAtomicService failed.");
            }
            if (!Compressor.checkContinueBundleNameIsValid(string)) {
                LOG.error("checkContinueBundleNameIsValid failed.");
                throw new BundleException("compressHsp failed.");
            }
            if (!Compressor.checkStageOverlayCfg(string)) {
                LOG.error("checkStageOverlayCfg failed.");
                throw new BundleException("checkStageOverlayCfg failed.");
            }
            String string2 = ModuleJsonUtil.parseModuleType(string);
            if (!TYPE_SHARED.equals(string2)) {
                LOG.error("module type must be shared.");
                throw new BundleException("compressHsp failed.");
            }
        }
        this.compressHSPMode(utility);
        Compressor.buildHash(utility);
    }

    private void compressHap(Utility utility) throws BundleException {
        if (utility.getJsonPath().isEmpty() && !utility.getBinPath().isEmpty()) {
            this.compressHapMode(utility);
            return;
        }
        Compressor.setGenerateBuildHash(utility);
        if (Compressor.isModuleJSON(utility.getJsonPath())) {
            String string;
            if (!Compressor.checkStageHap(utility)) {
                LOG.error("checkStageHap failed.");
                throw new BundleException("checkStageHap failed.");
            }
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            String string2 = optional.get();
            String string3 = ModuleJsonUtil.parseModuleType(string2);
            if (TYPE_SHARED.equals(string3)) {
                LOG.warning("Compress mode is hap, but module type is shared.");
            }
            if (TYPE_SHARED.equals(string = ModuleJsonUtil.parseStageBundleType(string2))) {
                LOG.warning("Compress mode is hap, but app type is shared.");
            }
            this.compressHapModeForModule(utility);
            Compressor.buildHash(utility);
        } else {
            this.compressHapMode(utility);
            Compressor.buildHash(utility);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasGenerateBuildHash(Utility utility) throws BundleException {
        File file = new File(utility.getJsonPath());
        if (!file.exists()) {
            LOG.error("Compressor::hasGenerateBuildHash failed for json file not exist");
            throw new BundleException("Compressor::hasGenerateBuildHash failed for json file not exist");
        }
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            fileInputStream = new FileInputStream(file);
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null || !jSONObject.containsKey(APP) || !jSONObject.containsKey(MODULE)) {
                LOG.error("json file is invalid.");
                throw new BundleException("json file is invalid.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
            JSONObject jSONObject3 = jSONObject.getJSONObject(MODULE);
            if (jSONObject2.containsKey(GENERATE_BUILD_HASH) || jSONObject3.containsKey(GENERATE_BUILD_HASH)) {
                bl = true;
            }
        }
        catch (BundleException bundleException) {
            try {
                LOG.error("Compressor::hasGenerateBuildHash failed.");
                throw new BundleException("Compressor::hasGenerateBuildHash failed.");
                catch (JSONException | IOException exception) {
                    LOG.error("Compressor::hasGenerateBuildHash failed for json file is invalid." + exception.getMessage());
                    throw new BundleException("Compressor::hasGenerateBuildHash failed.");
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fileInputStream);
                throw throwable;
            }
        }
        FileUtils.closeStream(fileInputStream);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setGenerateBuildHash(Utility utility) throws BundleException {
        if (utility.isBuildHashFinish()) return;
        if (!Compressor.hasGenerateBuildHash(utility)) {
            return;
        }
        Compressor.copyFileToTempDir(utility);
        File file = new File(utility.getJsonPath());
        if (!file.exists()) {
            LOG.error("Compressor::setGenerateBuildHash failed for json file not exist");
            throw new BundleException("Compressor::setGenerateBuildHash failed for json file not exist");
        }
        FileInputStream fileInputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileInputStream = new FileInputStream(file);
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (!jSONObject.containsKey(APP) || !jSONObject.containsKey(MODULE)) {
                LOG.error("json file is invalid.");
                throw new BundleException("json file is invalid.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
            JSONObject jSONObject3 = jSONObject.getJSONObject(MODULE);
            if (jSONObject2.containsKey(GENERATE_BUILD_HASH) && jSONObject2.getBoolean(GENERATE_BUILD_HASH).booleanValue()) {
                utility.setGenerateBuildHash(true);
            } else if (jSONObject3.containsKey(GENERATE_BUILD_HASH) && jSONObject3.getBoolean(GENERATE_BUILD_HASH).booleanValue()) {
                utility.setGenerateBuildHash(true);
            }
            jSONObject2.remove(GENERATE_BUILD_HASH);
            jSONObject3.remove(GENERATE_BUILD_HASH);
            String string = JSON.toJSONString((Object)jSONObject, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(utility.getJsonPath()), StandardCharsets.UTF_8));
            bufferedWriter.write(string);
        }
        catch (BundleException bundleException) {
            try {
                LOG.error("Compressor::setGenerateBuildHash failed.");
                throw new BundleException("Compressor::setGenerateBuildHash failed.");
                catch (JSONException | IOException | NullPointerException exception) {
                    LOG.error("Compressor::setGenerateBuildHash failed, json data err: " + exception.getMessage());
                    throw new BundleException("Compressor::setGenerateBuildHash failed, json data err.");
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fileInputStream);
                if (bufferedWriter == null) throw throwable;
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    LOG.error("Compressor::setGenerateBuildHash failed for IOException " + iOException.getMessage());
                    throw new BundleException("Compressor::setGenerateBuildHash failed.");
                }
            }
        }
        FileUtils.closeStream(fileInputStream);
        if (bufferedWriter == null) return;
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            LOG.error("Compressor::setGenerateBuildHash failed for IOException " + iOException.getMessage());
            throw new BundleException("Compressor::setGenerateBuildHash failed.");
        }
    }

    private static void copyFileToTempDir(Utility utility) throws BundleException {
        String string = utility.getJsonPath();
        File file = new File(string);
        if (!file.exists()) {
            LOG.error("Compressor::copyFileToTempDir failed for json file not found.");
            throw new BundleException("Compressor::copyFileToTempDir failed for json file not found.");
        }
        String string2 = file.getParent();
        String string3 = TEMP_DIR + File.separator + UUID.randomUUID();
        Compressor.mkdir(new File(string2 + File.separator + string3));
        String string4 = Compressor.isModuleJSON(utility.getJsonPath()) ? MODULE_JSON : CONFIG_JSON;
        String string5 = string2 + File.separator + string3 + File.separator + string4;
        try (FileInputStream fileInputStream = new FileInputStream(string);
             FileOutputStream fileOutputStream = new FileOutputStream(string5);){
            int n;
            byte[] byArray = new byte[1444];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            utility.setJsonPath(string5);
        }
        catch (IOException iOException) {
            LOG.error("Compressor::copyFileToTempDir failed, IOException: " + iOException.getMessage());
            throw new BundleException("Compressor::copyFileToTempDir failed.");
        }
    }

    private static void mkdir(File file) {
        if (null != file && !file.exists()) {
            Compressor.mkdir(file.getParentFile());
            file.mkdir();
        }
    }

    private static void buildHash(Utility utility) throws BundleException {
        if (utility.isBuildHashFinish() || !utility.getGenerateBuildHash()) {
            return;
        }
        String string = utility.getOutPath();
        String string2 = Compressor.getSHA256(string);
        try {
            Compressor.putBuildHash(utility, string2);
        }
        catch (IOException iOException) {
            LOG.error("Compressor::putBuildHash failed, " + iOException.getMessage());
            throw new BundleException("Compressor::putBuildHash failed.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] checkSum(String string) throws BundleException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            int n;
            byte[] byArray = new byte[1024];
            MessageDigest messageDigest = MessageDigest.getInstance(SHA_256);
            do {
                if ((n = ((InputStream)fileInputStream).read(byArray)) <= 0) continue;
                messageDigest.update(byArray, 0, n);
            } while (n != -1);
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            LOG.error("Compressor::checkSum failed, IOException or NoSuchAlgorithmException: " + exception.getMessage());
            throw new BundleException("Compressor::checkSum failed.");
        }
    }

    public static String getSHA256(String string) throws BundleException {
        byte[] byArray = Compressor.checkSum(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void putBuildHash(Utility utility, String string) throws BundleException, IOException {
        if (utility.isBuildHashFinish()) {
            return;
        }
        String string2 = utility.getJsonPath();
        File file = new File(string2);
        if (!file.exists()) {
            LOG.error("Compressor::putBuildHash failed for json file not exist");
            throw new BundleException("Compressor::putBuildHash failed for json file not exist");
        }
        FileInputStream fileInputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileInputStream = new FileInputStream(file);
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            JSONObject jSONObject2 = jSONObject.getJSONObject(MODULE);
            jSONObject2.put(BUILD_HASH, (Object)string);
            String string3 = JSON.toJSONString((Object)jSONObject, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), StandardCharsets.UTF_8));
            bufferedWriter.write(string3);
        }
        catch (IOException iOException) {
            try {
                LOG.error("Compressor::putBuildHash failed, IOException: " + iOException.getMessage());
                throw new BundleException("Compressor::putBuildHash failed.");
                catch (NullPointerException nullPointerException) {
                    LOG.error("Compressor::putBuildHash failed, json data err: " + nullPointerException.getMessage());
                    throw new BundleException("Compressor::putBuildHash failed, json data err.");
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(fileInputStream);
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                throw throwable;
            }
        }
        FileUtils.closeStream(fileInputStream);
        if (bufferedWriter != null) {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        utility.setBuildHashFinish(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkAppAtomicServiceCompressedSizeValid(Utility utility) {
        if (!utility.getMode().equals(APP) && !utility.getMode().equals("fastApp")) {
            return true;
        }
        File file = new File(utility.getOutPath());
        ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
        try (ZipFile zipFile = new ZipFile(file);){
            Object object;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object == null || !this.hapVerifyInfoMap.containsKey(((ZipEntry)object).getName())) continue;
                this.hapVerifyInfoMap.get(((ZipEntry)object).getName()).setFileLength(((ZipEntry)object).getCompressedSize());
                arrayList.add(this.hapVerifyInfoMap.get(((ZipEntry)object).getName()));
            }
            if (arrayList.isEmpty()) {
                LOG.error("Compressor::checkAppAtomicServiceCompressedSizeValid no hapVerifyInfo.");
                boolean bl = false;
                return bl;
            }
            object = ((HapVerifyInfo)arrayList.get(0)).getBundleType();
            if (!((String)object).equals(ATOMIC_SERVICE)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = ((HapVerifyInfo)arrayList.get(0)).isStageModule();
            if (!bl) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = HapVerify.checkFileSizeIsValid(arrayList);
            return bl3;
        }
        catch (IOException iOException) {
            LOG.error("Compressor::checkAppAtomicServiceCompressedSizeValid file not found exception: " + iOException.getMessage());
            return false;
        }
        catch (BundleException bundleException) {
            LOG.error("Compressor::checkAppAtomicServiceCompressedSizeValid Bundle exception.");
            return false;
        }
    }

    private static boolean checkStageHap(Utility utility) throws BundleException {
        Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
        String string = optional.get();
        if (!Compressor.checkStageAsanTsanEnabledValid(string)) {
            LOG.error("checkStageAsanTsanEnabledValid failed.");
            return false;
        }
        if (!Compressor.checkStageHwasanEnabledValid(string)) {
            LOG.error("checkStageHwasanEnabledValid failed.");
            return false;
        }
        if (!Compressor.checkStageUbsanEnabledValid(string)) {
            LOG.error("checkStageUbsanEnabledValid failed.");
            return false;
        }
        if (!Compressor.checkStageAtomicService(string)) {
            LOG.error("checkStageAtomicService failed.");
            return false;
        }
        if (!Compressor.checkContinueBundleNameIsValid(string)) {
            LOG.error("checkContinueBundleNameIsValid failed.");
            return false;
        }
        return true;
    }

    private static boolean checkStageAsanTsanEnabledValid(String string) throws BundleException {
        boolean bl = ModuleJsonUtil.getStageAsanEnabled(string);
        boolean bl2 = ModuleJsonUtil.getStageTsanEnabled(string);
        if (bl && bl2) {
            LOG.error("asanEnabled and tsanEnabled cannot be true at the same time.");
            return false;
        }
        return true;
    }

    private static boolean checkStageHwasanEnabledValid(String string) throws BundleException {
        boolean bl = ModuleJsonUtil.getStageAsanEnabled(string);
        boolean bl2 = ModuleJsonUtil.getStageTsanEnabled(string);
        boolean bl3 = ModuleJsonUtil.getStageGwpAsanEnabled(string);
        boolean bl4 = ModuleJsonUtil.getStageHwasanEnabled(string);
        if (bl4 && bl) {
            LOG.error("hwasanEnabled and asanEnabled cannot be true at the same time.");
            return false;
        }
        if (bl4 && bl2) {
            LOG.error("hwasanEnabled and tsanEnabled cannot be true at the same time.");
            return false;
        }
        if (bl4 && bl3) {
            LOG.error("hwasanEnabled and GWPAsanEnabled cannot be true at the same time.");
            return false;
        }
        return true;
    }

    private static boolean checkContinueBundleNameIsValid(String string) throws BundleException {
        Map<String, List<String>> map = ModuleJsonUtil.getAbilityContinueBundleNameMap(string);
        String string2 = ModuleJsonUtil.parseBundleName(string);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                if (!string2.equals(list.get(i))) continue;
                LOG.error("continueBundleName cannot include self.");
                return false;
            }
        }
        return true;
    }

    private static boolean checkStageUbsanEnabledValid(String string) throws BundleException {
        boolean bl = ModuleJsonUtil.getStageAsanEnabled(string);
        boolean bl2 = ModuleJsonUtil.getStageTsanEnabled(string);
        boolean bl3 = ModuleJsonUtil.getStageHwasanEnabled(string);
        boolean bl4 = ModuleJsonUtil.getStageUbsanEnabled(string);
        if (bl4 && bl) {
            LOG.error("ubsanEnabled and asanEnabled cannot be true at the same time.");
            return false;
        }
        if (bl4 && bl2) {
            LOG.error("ubsanEnabled and tsanEnabled cannot be true at the same time.");
            return false;
        }
        if (bl4 && bl3) {
            LOG.error("ubsanEnabled and hwasanEnabled cannot be true at the same time.");
            return false;
        }
        return true;
    }

    private static boolean checkStageAtomicService(String string) throws BundleException {
        if (!ModuleJsonUtil.isModuleAtomicServiceValid(string)) {
            LOG.error("check module atomicService failed.");
            return false;
        }
        if (!ModuleJsonUtil.checkEntryInAtomicService(string)) {
            LOG.error("checkEntryInAtomicService failed.");
            return false;
        }
        if (!ModuleJsonUtil.checkAtomicServiceInstallationFree(string)) {
            LOG.error("check atomic service installationFree failed.");
            return false;
        }
        return true;
    }

    private static boolean checkStageOverlayCfg(String string) throws BundleException {
        String string2;
        String string3 = ModuleJsonUtil.getStageTargetModuleName(string);
        if (!string3.isEmpty()) {
            if (ModuleJsonUtil.isExistedStageRequestPermissions(string)) {
                LOG.error("targetModuleName cannot be existed with requestPermissions.");
                return false;
            }
            if (string3.equals(ModuleJsonUtil.parseStageModuleName(string))) {
                LOG.error("targetModuleName cannot be same with name in the overlay module.");
                return false;
            }
        } else if (ModuleJsonUtil.isExistedStageModuleTargetPriority(string)) {
            LOG.error("targetPriority cannot be existed without the targetModuleName in module.json.");
            return false;
        }
        if (!(string2 = ModuleJsonUtil.getStageTargetBundleName(string)).isEmpty()) {
            if (string3.isEmpty()) {
                LOG.error("targetModuleName is necessary in the overlay bundle.");
                return false;
            }
            if (string2.equals(ModuleJsonUtil.parseBundleName(string))) {
                LOG.error("targetBundleName cannot be same with the bundleName.");
                return false;
            }
        } else if (ModuleJsonUtil.isExistedStageAppTargetPriority(string)) {
            LOG.error("targetPriority cannot be existed without the targetBundleName in app.json.");
            return false;
        }
        return true;
    }

    private static boolean checkFAHap(Utility utility) throws BundleException {
        Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
        String string = optional.get();
        return Compressor.checkFAAsanEnabledValid(string);
    }

    private static boolean checkFAAsanEnabledValid(String string) throws BundleException {
        boolean bl = ModuleJsonUtil.getFAAsanEnabled(string);
        boolean bl2 = ModuleJsonUtil.getFADebug(string);
        if (bl && !bl2) {
            LOG.error("asanEnabled is not supported for Release.");
            return false;
        }
        return true;
    }

    private void compressHapMode(Utility utility) throws BundleException {
        String string;
        String string2;
        this.pathToFile(utility, utility.getJsonPath(), "", false);
        this.pathToFile(utility, utility.getProfilePath(), "", false);
        if (!utility.getIndexPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            string2 = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR;
            this.pathToFile(utility, utility.getIndexPath(), string2, false);
        }
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
        if (!utility.getFilePath().isEmpty()) {
            this.pathToFile(utility, utility.getFilePath(), "", false);
        }
        if (!utility.getResPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            string2 = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + RESOURCES_DIR_NAME;
            string = utility.getDeviceType().replace(SEMICOLON, "").trim();
            if (DEVICE_TYPE_FITNESSWATCH.equals(string) || DEVICE_TYPE_FITNESSWATCH_NEW.equals(string)) {
                string2 = RES_DIR_NAME;
            }
            this.pathToFile(utility, utility.getResPath(), string2, false);
        }
        if (!utility.getResourcesPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            string2 = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + RESOURCES_DIR_NAME;
            this.pathToFile(utility, utility.getResourcesPath(), string2, false);
        }
        if (!utility.getRpcidPath().isEmpty()) {
            string2 = "";
            this.pathToFile(utility, utility.getRpcidPath(), string2, false);
        }
        if (!utility.getPackInfoPath().isEmpty()) {
            string2 = "";
            this.pathToFile(utility, utility.getPackInfoPath(), string2, false);
        }
        if (!utility.getAssetsPath().isEmpty()) {
            this.pathToFile(utility, utility.getAssetsPath(), ASSETS_DIR_NAME, false);
        }
        if (!utility.getBinPath().isEmpty()) {
            this.pathToFile(utility, utility.getBinPath(), "", false);
        }
        if (!utility.getFormatedDirList().isEmpty()) {
            for (int i = 0; i < utility.getFormatedDirList().size(); ++i) {
                string = new File(utility.getFormatedDirList().get(i)).getName() + File.separator;
                this.pathToFile(utility, utility.getFormatedDirList().get(i), string, false);
            }
        }
        this.compressHapModeMultiple(utility);
    }

    private void compressHapModeForModule(Utility utility) throws BundleException {
        String string;
        String string2;
        this.pathToFile(utility, utility.getJsonPath(), "", false);
        this.pathToFile(utility, utility.getProfilePath(), "", false);
        if (!utility.getIndexPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string2 = "";
            this.pathToFile(utility, utility.getIndexPath(), string2, false);
        }
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
        if (!utility.getANPath().isEmpty()) {
            this.pathToFile(utility, utility.getANPath(), AN_DIR_NAME, false);
        }
        if (!utility.getAPPath().isEmpty()) {
            this.pathToFile(utility, utility.getAPPath(), AP_PATH_NAME, false);
        }
        if (!utility.getFilePath().isEmpty()) {
            this.pathToFile(utility, utility.getFilePath(), "", false);
        }
        if (!utility.getResPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            string2 = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + RESOURCES_DIR_NAME;
            string = utility.getDeviceType().replace(SEMICOLON, "").trim();
            if (DEVICE_TYPE_FITNESSWATCH.equals(string) || DEVICE_TYPE_FITNESSWATCH_NEW.equals(string)) {
                string2 = RES_DIR_NAME;
            }
            this.pathToFile(utility, utility.getResPath(), string2, false);
        }
        if (!utility.getResourcesPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string2 = RESOURCES_DIR_NAME;
            this.pathToFile(utility, utility.getResourcesPath(), string2, false);
        }
        if (!utility.getJsPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string2 = JS_PATH;
            this.pathToFile(utility, utility.getJsPath(), string2, false);
        }
        if (!utility.getEtsPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string2 = ETS_PATH;
            this.pathToFile(utility, utility.getEtsPath(), string2, false);
        }
        if (!utility.getHnpPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string2 = HNP_PATH;
            this.pathToFile(utility, utility.getHnpPath(), string2, false);
        }
        if (!utility.getRpcidPath().isEmpty()) {
            string2 = "";
            this.pathToFile(utility, utility.getRpcidPath(), string2, false);
        }
        if (!utility.getAssetsPath().isEmpty()) {
            this.pathToFile(utility, utility.getAssetsPath(), ASSETS_DIR_NAME, false);
        }
        if (!utility.getBinPath().isEmpty()) {
            this.pathToFile(utility, utility.getBinPath(), "", false);
        }
        if (!utility.getPackInfoPath().isEmpty()) {
            this.pathToFile(utility, utility.getPackInfoPath(), "", false);
        }
        if (!utility.getFormatedDirList().isEmpty()) {
            for (int i = 0; i < utility.getFormatedDirList().size(); ++i) {
                string = new File(utility.getFormatedDirList().get(i)).getName() + File.separator;
                this.pathToFile(utility, utility.getFormatedDirList().get(i), string, false);
            }
        }
        if (!utility.getPkgContextPath().isEmpty()) {
            this.pathToFile(utility, utility.getPkgContextPath(), "", false);
        }
        this.compressHapModeMultiple(utility);
    }

    private void compressHapModeMultiple(Utility utility) throws BundleException {
        for (String string : utility.getFormattedSoPathList()) {
            this.pathToFile(utility, string, SO_ARM64_DIR_NAME, false);
        }
        if (utility.getFormattedSoPathList().size() == 0 && !utility.getSoDir().isEmpty()) {
            this.pathToFile(utility, utility.getSoDir(), SO_DIR_NAME, false);
        }
        for (String string : utility.getFormattedAbilitySoPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        for (String string : utility.getFormattedDexPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        for (String string : utility.getFormattedAbcPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        for (String string : utility.getFormattedApkPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        for (String string : utility.getFormattedJarPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        for (String string : utility.getFormattedTxtPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        if (!utility.getSharedLibsPath().isEmpty()) {
            this.pathToFile(utility, utility.getSharedLibsPath(), SHARED_LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
    }

    private void compressHarMode(Utility utility) throws BundleException {
        this.pathToFile(utility, utility.getJsonPath(), "", false);
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
        if (!utility.getResPath().isEmpty()) {
            this.pathToFile(utility, utility.getResPath(), RESOURCES_DIR_NAME, false);
        }
        if (!utility.getResourcesPath().isEmpty()) {
            this.pathToFile(utility, utility.getResourcesPath(), RESOURCES_DIR_NAME, false);
        }
        if (!utility.getAssetsPath().isEmpty()) {
            this.pathToFile(utility, utility.getAssetsPath(), ASSETS_DIR_NAME, false);
        }
        for (String string : utility.getFormattedJarPathList()) {
            this.pathToFile(utility, string, "", false);
        }
        for (String string : utility.getFormattedTxtPathList()) {
            this.pathToFile(utility, string, "", false);
        }
    }

    private void compressAppMode(Utility utility) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(utility.getOutPath().trim());
        String string = file.getParentFile().getParent() + File.separator + TEMP_HAP_DIR;
        String string2 = file.getParentFile().getParent() + File.separator + TEMP_HSP_DIR;
        try {
            Object object3;
            this.pathToFile(utility, utility.getJsonPath(), "", false);
            if (!utility.getCertificatePath().isEmpty()) {
                this.pathToFile(utility, utility.getCertificatePath(), "", false);
            }
            if (!utility.getSignaturePath().isEmpty()) {
                this.pathToFile(utility, utility.getSignaturePath(), "", false);
            }
            if (!((File)(object3 = new File(string))).exists()) {
                ((File)object3).mkdirs();
            }
            for (String object22 : utility.getFormattedHapPathList()) {
                File file2 = new File(object22.trim());
                String string3 = object3 + File.separator + file2.getName();
                arrayList.add(string3);
                try {
                    this.compressPackinfoIntoHap(object22, string3, utility.getPackInfoPath(), utility.getCompressLevel());
                }
                catch (IOException iOException) {
                    LOG.error("Compressor::compressAppMode compress pack.info into hap failed: " + iOException.getMessage());
                    throw new BundleException("Compressor::compressAppMode compress pack.info into hap failed.");
                }
            }
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            for (String string4 : utility.getFormattedHspPathList()) {
                File file3 = new File(string4.trim());
                String string5 = file2 + File.separator + file3.getName();
                arrayList.add(string5);
                try {
                    this.compressPackinfoIntoHap(string4, string5, utility.getPackInfoPath(), utility.getCompressLevel());
                }
                catch (IOException iOException) {
                    LOG.error("Compressor::compressAppMode compress pack.info into hsp failed: " + iOException.getMessage());
                    throw new BundleException("Compressor::compressAppMode compress pack.info into hsp failed.");
                }
            }
            if (!this.checkHapIsValid(arrayList, utility.getSharedApp())) {
                LOG.error("Compressor::compressFile verify failed, check version, apiVersion,moduleName,packageName.");
                throw new BundleException("Compressor::compressFile verify failed, check version, apiVersion,moduleName,packageName.");
            }
            for (String string6 : arrayList) {
                HapVerifyInfo hapVerifyInfo = this.hapVerifyInfoMap.get(Compressor.getFileNameByPath(string6));
                if (hapVerifyInfo != null && !hapVerifyInfo.isDebug()) {
                    this.pathToFile(utility, string6, "", true);
                    continue;
                }
                this.pathToFile(utility, string6, "", false);
            }
            if (!utility.getEntryCardPath().isEmpty()) {
                String string7 = ENTRYCARD_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + ENTRYCARD_BASE_NAME + ENTRYCARD_SNAPSHOT_NAME;
                for (String string8 : utility.getformattedEntryCardPathList()) {
                    this.pathToFile(utility, string8, string7, true);
                }
            }
            if (!utility.getPackResPath().isEmpty()) {
                this.pathToFile(utility, utility.getPackResPath(), "", false);
            }
            File file4 = new File(utility.getPackInfoPath());
            this.compressFile(utility, file4, "", false);
            this.packEncryptJsonFile(utility);
        }
        catch (BundleException bundleException) {
            LOG.error("Compressor::compressAppMode compress failed. msg: " + bundleException.getMessage());
            throw new BundleException("Compressor::compressAppMode compress failed.");
        }
        finally {
            for (String string9 : arrayList) {
                Compressor.deleteFile(string9);
            }
            Compressor.deleteFile(string);
            Compressor.deleteFile(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compressFastAppMode(Utility utility) throws BundleException {
        Path path = Paths.get(utility.getOutPath().trim(), new String[0]);
        Path path2 = null;
        try {
            Path path3;
            Path path4;
            path2 = Files.createTempDirectory(path.getParent(), TEMP_DIR, new FileAttribute[0]);
            Path path5 = Paths.get(utility.getPackInfoPath(), new String[0]);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : utility.getFormattedHapPathList()) {
                path4 = Paths.get(string, new String[0]);
                path3 = PackageUtil.pack(path4, path5, path2, utility.getCompressLevel());
                if (path3 == null) continue;
                arrayList.add(path3.toString());
            }
            for (String string : utility.getFormattedHspPathList()) {
                path4 = Paths.get(string, new String[0]);
                path3 = PackageUtil.pack(path4, path5, path2, utility.getCompressLevel());
                if (path3 == null) continue;
                arrayList.add(path3.toString());
            }
            if (!this.checkHapIsValid(arrayList, utility.getSharedApp())) {
                String string = "Compressor::checkHapIsValid verify failed, check version, apiVersion, moduleName, packageName.";
                LOG.error(string);
                throw new BundleException(string);
            }
            this.packFastApp(utility, arrayList);
            if (path2 == null) return;
        }
        catch (IOException iOException) {
            try {
                LOG.error("Compressor::compressAppMode compress failed: " + iOException.getMessage());
                throw new BundleException("Compressor::compressAppMode compress failed.");
            }
            catch (Throwable throwable) {
                if (path2 == null) throw throwable;
                PackageUtil.rmdir(path2);
                throw throwable;
            }
        }
        PackageUtil.rmdir(path2);
        return;
    }

    private void packFastApp(Utility utility, List<String> list) throws BundleException {
        this.pathToFile(utility, utility.getPackInfoPath(), "", false);
        this.packEncryptJsonFile(utility);
        for (String object : list) {
            HapVerifyInfo hapVerifyInfo = this.hapVerifyInfoMap.get(Compressor.getFileNameByPath(object));
            if (hapVerifyInfo != null && !hapVerifyInfo.isDebug()) {
                this.pathToFile(utility, object, "", true);
                continue;
            }
            this.pathToFile(utility, object, "", false);
        }
        if (!utility.getEntryCardPath().isEmpty()) {
            String string = ENTRYCARD_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + ENTRYCARD_BASE_NAME + ENTRYCARD_SNAPSHOT_NAME;
            for (String string2 : utility.getformattedEntryCardPathList()) {
                this.pathToFile(utility, string2, string, true);
            }
        }
        if (!utility.getPackResPath().isEmpty()) {
            this.pathToFile(utility, utility.getPackResPath(), "", false);
        }
        if (!utility.getCertificatePath().isEmpty()) {
            this.pathToFile(utility, utility.getCertificatePath(), "", false);
        }
        if (!utility.getSignaturePath().isEmpty()) {
            this.pathToFile(utility, utility.getSignaturePath(), "", false);
        }
    }

    private void compressAppModeForMultiProject(Utility utility) throws BundleException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(utility.getOutPath().trim());
        String string = file.getParentFile().getParent() + File.separator + TEMP_HAP_DIR;
        String string2 = file.getParentFile().getParent() + File.separator + TEMP_SELECTED_HAP_DIR;
        try {
            Object object;
            File file2 = new File(string2);
            FileUtils.makeDir(file2);
            File file3 = new File(string);
            FileUtils.makeDir(file3);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string3 = Compressor.disposeApp(utility, arrayList2, string2);
            string3 = Compressor.disposeHap(utility, arrayList2, string2, string3);
            String string4 = file2.getPath() + File.separator + PACKINFO_NAME;
            this.writePackInfo(string4, string3);
            for (String string5 : arrayList2) {
                String string6 = file2.getPath() + File.separator + string5;
                File file4 = new File(string6.trim());
                String string7 = file3.getPath() + File.separator + file4.getName();
                arrayList.add(string7);
                this.compressPackinfoIntoHap(string6, string7, string4, utility.getCompressLevel());
            }
            if (!this.checkHapIsValid(arrayList, false)) {
                object = "Compressor::compressAppModeForMultiProject There are some haps with different version code or duplicated moduleName or packageName.";
                throw new BundleException((String)object);
            }
            for (String string5 : arrayList) {
                this.pathToFile(utility, string5, "", false);
            }
            object = new File(string4);
            this.compressFile(utility, (File)object, "", false);
            this.packEncryptJsonFile(utility);
        }
        catch (IOException | BundleException exception) {
            String string8 = "Compressor::compressAppModeForMultiProject file failed: " + exception.getMessage();
            LOG.error(string8);
            throw new BundleException(string8);
        }
        finally {
            Compressor.deleteFile(string);
            Compressor.deleteFile(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hapAddition(Utility utility) {
        File file = new File(utility.getAbsoluteHapPath());
        String string = file.getName();
        File file2 = new File(utility.getOutPath() + LINUX_FILE_SEPARATOR + string);
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.exists() && !file3.mkdirs()) {
            LOG.error("Compressor::hapAddition create out file parent directory failed.");
        }
        FileOutputStream fileOutputStream = null;
        CheckedOutputStream checkedOutputStream = null;
        String string2 = System.getProperty("user.dir");
        String string3 = string2 + LINUX_FILE_SEPARATOR + HAPADDITION_FOLDER_NAME;
        String string4 = BACKUP_PREFIX + string;
        String string5 = utility.getHapPath();
        try {
            this.copyHapFile(utility, string4);
            fileOutputStream = new FileOutputStream(file2);
            checkedOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            this.zipOut = new ZipArchiveOutputStream(checkedOutputStream);
            this.compressHapAddition(utility, string3);
            this.closeZipOutputStream();
        }
        catch (IOException | BundleException exception) {
            try {
                LOG.error("Compressor::HapAddition hapFile not found exception" + exception.getMessage());
                this.copyFileSafely(string4, string5);
                this.closeZipOutputStream();
            }
            catch (Throwable throwable) {
                this.closeZipOutputStream();
                Utility.closeStream(this.zipOut);
                Utility.closeStream(checkedOutputStream);
                Utility.closeStream(fileOutputStream);
                Compressor.deleteFile(string4);
                Compressor.deleteFile(string3);
                throw throwable;
            }
            Utility.closeStream(this.zipOut);
            Utility.closeStream(checkedOutputStream);
            Utility.closeStream(fileOutputStream);
            Compressor.deleteFile(string4);
            Compressor.deleteFile(string3);
        }
        Utility.closeStream(this.zipOut);
        Utility.closeStream(checkedOutputStream);
        Utility.closeStream(fileOutputStream);
        Compressor.deleteFile(string4);
        Compressor.deleteFile(string3);
    }

    private void copyHapFile(Utility utility, String string) throws IOException, BundleException {
        File file = new File(utility.getAbsoluteHapPath());
        String string2 = System.getProperty("user.dir");
        String string3 = string2 + LINUX_FILE_SEPARATOR + string;
        File file2 = new File(string3);
        FileUtils.copyFile(file, file2);
        utility.setHapPath(string);
    }

    private void copyFileSafely(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            FileUtils.copyFile(file, file2);
        }
        catch (IOException | BundleException exception) {
            LOG.error("copyFileSafely failed: " + exception.getMessage());
        }
    }

    private static String readerFile(String string) throws IOException {
        byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private static void writeJsonFile(String string, String string2) throws BundleException {
        try (FileWriter fileWriter = new FileWriter(string2);){
            Object object = JSON.parse(string);
            String string3 = new String();
            if (object instanceof JSONArray) {
                JSONArray jSONArray = JSONArray.parseArray(string);
                string3 = JSON.toJSONString((Object)jSONArray, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue);
            } else {
                JSONObject jSONObject = JSONObject.parseObject(string);
                string3 = JSON.toJSONString((Object)jSONObject, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue);
            }
            fileWriter.write(string3);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            LOG.error("writeJsonFile failed, " + iOException.getMessage());
            throw new BundleException(iOException.getMessage());
        }
        catch (JSONException jSONException) {
            LOG.error("json file is invalid: " + jSONException.getMessage());
            throw new BundleException(jSONException.getMessage());
        }
    }

    private static void setUtilityParameter(String string, Utility utility) throws IOException {
        Path path2 = Paths.get(string, new String[0]);
        try (Stream<Path> stream = Files.walk(path2, 1, new FileVisitOption[0]);){
            stream.forEach(path -> {
                String string = path.getFileName().toString();
                String string2 = path.toString();
                switch (string) {
                    case "ets": {
                        utility.setEtsPath(string2);
                        break;
                    }
                    case "dir": {
                        utility.setLibPath(string2);
                        break;
                    }
                    case "an": {
                        utility.setANPath(string2);
                        break;
                    }
                    case "ap": {
                        utility.setAPPath(string2);
                        break;
                    }
                    case "resources": {
                        utility.setResourcesPath(string2);
                        break;
                    }
                    case "js": {
                        utility.setJsPath(string2);
                        break;
                    }
                    case "assets": {
                        utility.setAssetsPath(string2);
                        break;
                    }
                    case "maple": {
                        utility.setSoDir(string2);
                        break;
                    }
                    case "shared_libs": {
                        utility.setSharedLibsPath(string2);
                        break;
                    }
                    case "module.json": {
                        utility.setJsonPath(string2);
                        break;
                    }
                    case "resources.index": {
                        utility.setIndexPath(string2);
                        break;
                    }
                    case "pack.info": {
                        utility.setPackInfoPath(string2);
                    }
                }
            });
        }
    }

    private void compressHapAddition(Utility utility, String string) throws BundleException {
        String string2;
        String string3;
        Compressor.unpackHap(utility.getHapPath(), string);
        try {
            string3 = Compressor.readerFile(utility.getJsonPath());
            string2 = System.getProperty("user.dir");
            String string4 = string2 + LINUX_FILE_SEPARATOR + TARGET_FILE_PATH;
            File file = new File(string4);
            if (!file.exists() && !file.mkdirs()) {
                LOG.error("Compressor::compressHapAddition create target file parent directory failed.");
            }
            String string5 = string4 + LINUX_FILE_SEPARATOR + ADDITION_JSON;
            Compressor.writeJsonFile(string3, string5);
        }
        catch (JSONException | IOException | BundleException exception) {
            String string6 = "Compressor::compressHapAddition generate addition.json file failed, " + exception.getMessage();
            LOG.error(string6);
            throw new BundleException(string6);
        }
        try {
            Compressor.setUtilityParameter(string, utility);
        }
        catch (IOException iOException) {
            string2 = "Compressor::compressHapAddition setUtilityParameter failed.";
            LOG.error(string2);
            throw new BundleException(string2);
        }
        if (utility.getHapPath().endsWith(HAP_SUFFIX)) {
            this.compressHap(utility);
        } else if (utility.getHapPath().endsWith(HSP_SUFFIX)) {
            this.compressHsp(utility);
        } else {
            string3 = "Compressor::compressHapAddition compressFile failed.";
            LOG.error(string3);
            throw new BundleException(string3);
        }
    }

    private static String disposeApp(Utility utility, List<String> list, String string) throws BundleException {
        if (utility.getFormattedAppList().isEmpty()) {
            return "";
        }
        String string2 = "";
        try {
            for (String string3 : utility.getFormattedAppList()) {
                string2 = Compressor.selectHapInApp(string3, list, string, string2);
            }
        }
        catch (IOException | BundleException exception) {
            String string4 = "Compressor:disposeApp disposeApp failed.";
            LOG.error(string4);
            throw new BundleException(string4);
        }
        return string2;
    }

    private static String selectHapInApp(String string, List<String> list, String string2, String string3) throws BundleException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Compressor.copyHapAndHspFromApp(string, arrayList, list, string2);
        String string4 = FileUtils.getJsonInZips(new File(string), PACKINFO_NAME);
        if (string4.isEmpty()) {
            String string5 = "Compressor:selectHapInApp failed, app has no pack.info.";
            LOG.error(string5);
            throw new BundleException(string5);
        }
        if (string3.isEmpty()) {
            string3 = string4;
            return string3;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string6 : arrayList) {
            hashMap.put(string6, Compressor.readModlueNameFromHap(string2 + File.separator + string6));
        }
        return ModuleJsonUtil.mergeTwoPackInfoByPackagePair(string3, string4, hashMap);
    }

    private static void copyHapAndHspFromApp(String string, List<String> list, List<String> list2, String string2) throws BundleException {
        ZipInputStream zipInputStream = null;
        ZipFile zipFile = null;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        ZipEntry zipEntry = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            zipFile = new ZipFile(string);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                File file = null;
                if (!zipEntry.getName().endsWith(HAP_SUFFIX) && !zipEntry.getName().endsWith(HSP_SUFFIX)) continue;
                if (list2.contains(zipEntry.getName())) {
                    LOG.error("Compressor::copyHapFromApp file duplicated, file is " + zipEntry.getName() + ".");
                    throw new BundleException("Compressor::copyHapFromApp file duplicated, file is " + zipEntry.getName() + ".");
                }
                file = new File(string2 + File.separator + zipEntry.getName());
                list2.add(file.getName());
                list.add(file.getName());
                fileOutputStream = new FileOutputStream(file);
                inputStream = zipFile.getInputStream(zipEntry);
                byte[] byArray = new byte[40960];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            try {
                String string3 = "Compressor:copyHapFromApp app path not found.";
                LOG.error(string3);
                throw new BundleException(string3);
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipInputStream);
                Utility.closeStream(zipFile);
                Utility.closeStream(fileOutputStream);
                Utility.closeStream(inputStream);
                throw throwable;
            }
        }
        Utility.closeStream(zipInputStream);
        Utility.closeStream(zipFile);
        Utility.closeStream(fileOutputStream);
        Utility.closeStream(inputStream);
    }

    private static String readModlueNameFromHap(String string) throws BundleException {
        String string2 = "";
        File file = new File(string);
        if (Compressor.isModuleHap(string)) {
            String string3 = FileUtils.getJsonInZips(file, MODULE_JSON);
            string2 = ModuleJsonUtil.parseStageModuleName(string3);
        } else {
            String string4 = FileUtils.getJsonInZips(file, CONFIG_JSON);
            string2 = ModuleJsonUtil.parseFaModuleName(string4);
        }
        return string2;
    }

    private static String disposeHap(Utility utility, List<String> list, String string, String string2) throws BundleException, IOException {
        if (utility.getFormattedHapList().isEmpty()) {
            return string2;
        }
        for (String string3 : utility.getFormattedHapList()) {
            if (list.contains(new File(string3).getName())) {
                LOG.error("Compressor::disposeHap file duplicated, file is " + new File(string3).getName() + ".");
                throw new BundleException("Compressor::disposeHap file duplicated, file is " + new File(string3).getName() + ".");
            }
            File file = new File(string3);
            list.add(file.getName());
            FileUtils.copyFile(file, new File(string + File.separator + file.getName()));
            String string4 = FileUtils.getJsonInZips(file, PACKINFO_NAME);
            if (string4.isEmpty()) {
                String string5 = "Compressor::disposeHap failed, hap has no pack.info.";
                LOG.error(string5);
                throw new BundleException(string5);
            }
            if (string2.isEmpty()) {
                string2 = string4;
                continue;
            }
            string2 = ModuleJsonUtil.mergeTwoPackInfo(string2, string4);
        }
        return string2;
    }

    private void writePackInfo(String string, String string2) throws BundleException, IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            fileWriter.write(string2);
        }
        catch (IOException iOException) {
            String string3 = "Compressor:writePackInfo failed.";
            LOG.error(string3);
            throw new BundleException(string3);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.flush();
                fileWriter.close();
            }
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[40960];
        while ((n = inputStream.read(byArray, 0, 40960)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressPackinfoIntoHap(String string, String string2, String string3, int n) throws IOException, BundleException {
        ZipFile zipFile = new ZipFile(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
        zipOutputStream.setLevel(n);
        try {
            ZipEntry zipEntry;
            Object object;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                object = new ZipEntry(enumeration.nextElement());
                if (PACKINFO_NAME.equals(((ZipEntry)object).getName())) continue;
                zipEntry = ((ZipEntry)object).getMethod() == 0 ? new ZipEntry((ZipEntry)object) : new ZipEntry(((ZipEntry)object).getName());
                zipOutputStream.putNextEntry(zipEntry);
                if (!((ZipEntry)object).isDirectory()) {
                    this.copy(zipFile.getInputStream((ZipEntry)object), zipOutputStream);
                }
                zipOutputStream.closeEntry();
            }
            object = new File(string3);
            zipEntry = this.getStoredZipEntry((File)object, PACKINFO_NAME);
            zipOutputStream.putNextEntry(zipEntry);
            try (FileInputStream fileInputStream = new FileInputStream((File)object);){
                int n2;
                byte[] byArray = new byte[40960];
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                }
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            LOG.error("Compressor::compressPackinfoIntoHap io exception.");
            throw new BundleException("Compressor::compressPackinfoIntoHap io exception.");
        }
        finally {
            zipFile.close();
            zipOutputStream.close();
        }
    }

    private static void deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    Compressor.deleteFile(fileArray[i].toString());
                }
            }
            file.delete();
        }
    }

    private void compressPackResMode(Utility utility) throws BundleException {
        Serializable serializable;
        if (!utility.getPackInfoPath().isEmpty()) {
            this.parsePackInfoJsonFile(utility, utility.getPackInfoPath());
            serializable = new File(utility.getPackInfoPath());
            this.infoSpecialProcess(utility, (File)serializable);
        }
        if (!utility.getEntryCardPath().isEmpty()) {
            this.getFileList(utility.getEntryCardPath());
            serializable = new ArrayList();
            for (String string : this.fileNameList) {
                if (string.endsWith(PNG_SUFFIX) || string.endsWith(UPPERCASE_PNG_SUFFIX)) {
                    String string2 = string.trim();
                    String[] stringArray = string2.replace("\\", LINUX_FILE_SEPARATOR).split(LINUX_FILE_SEPARATOR);
                    if (stringArray.length < 4) {
                        LOG.error("Compressor::compressPackResMode the hap file path is invalid, length: " + stringArray.length + ".");
                        continue;
                    }
                    String string3 = stringArray[stringArray.length - 3];
                    if (!this.isThirdLevelDirectoryNameValid(string3)) {
                        LOG.error("Compressor::compressProcess compress failed third level directory name: " + string3 + " is invalid, please check it with reference to this example: zh_Hani_CN-vertical-car-mdpi-dark or zh_Hani_CN-vertical-car-mdpi.");
                        throw new BundleException("Compress failed third level directory name Error.");
                    }
                    String string4 = stringArray[stringArray.length - 1];
                    if (!this.isPicturing(string4, utility)) {
                        LOG.error("Compressor::compressProcess Compress pack.res failed, Invalid resource file name: " + string4 + ", correct format example is formName-2x2.png.");
                        throw new BundleException("Compress pack.res failed, Invalid resource file name: " + string4 + ", correct format example is formName-2x2.png.");
                    }
                    String string5 = stringArray[stringArray.length - 4] + LINUX_FILE_SEPARATOR + string4.substring(0, string4.lastIndexOf("."));
                    serializable.add(string5);
                    continue;
                }
                LOG.error("Compressor::compressProcess compress failed No image in PNG format is found.");
                throw new BundleException("Compress pack.res failed, compress failed No image in PNG format is found.");
            }
            for (String string : this.formNamesList) {
                if (serializable.contains(string)) continue;
                LOG.error("Compressor::compressProcess compress failed entryCard " + string + " has no related snapshot " + serializable.toString() + ".");
                throw new BundleException("Compress pack.res failed, compress failed entryCard has no related snapshot.");
            }
            this.pathToFileResMode(utility, utility.getEntryCardPath(), ENTRYCARD_NAME, false);
        }
    }

    private boolean isModelName(String string) {
        for (String string2 : this.list) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isThirdLevelDirectoryNameValid(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (ENTRYCARD_BASE_NAME.equals(string)) {
            return true;
        }
        int n = string.indexOf("_");
        if (n < 0) {
            return false;
        }
        String string2 = string.substring(0, n);
        int n2 = string.indexOf("_", n + 1);
        if (n2 < 0) {
            return false;
        }
        String string3 = string.substring(n + 1, n2);
        int n3 = string.indexOf("-", n2 + 1);
        if (n3 < 0) {
            return false;
        }
        String string4 = string.substring(n2 + 1, n3);
        if (!(this.checkLanguage(string2) && this.checkScript(string3) && this.checkCountry(string4))) {
            return false;
        }
        int n4 = string.indexOf("-", n3 + 1);
        if (n4 < 0) {
            return false;
        }
        String string5 = string.substring(n3 + 1, n4);
        int n5 = string.indexOf("-", n4 + 1);
        if (n5 < 0) {
            return false;
        }
        String string6 = string.substring(n4 + 1, n5);
        if (!this.checkOrientation(string5) || !this.checkDeviceType(string6)) {
            return false;
        }
        int n6 = string.indexOf("-", n5 + 1);
        if (n6 < 0) {
            String string7 = string.substring(n5 + 1, string.length());
            return this.checkScreenDensity(string7);
        }
        String string8 = string.substring(n5 + 1, n6);
        if (!this.checkScreenDensity(string8)) {
            return false;
        }
        int n7 = string.indexOf("-", n6 + 1);
        if (n7 < 0) {
            String string9 = string.substring(n6 + 1, string.length());
            return this.checkColorModeOrShape(string9);
        }
        if (!this.checkColorMode(string.substring(n6 + 1, n7))) {
            return false;
        }
        String string10 = string.substring(n7 + 1, string.length());
        return this.checkShape(string10);
    }

    private boolean checkLanguage(String string) {
        if (!Pattern.compile(REGEX_LANGUAGE).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess language " + string + " is not in ISO 639-1 list.");
            return false;
        }
        return true;
    }

    private boolean checkScript(String string) {
        if (!Pattern.compile(REGEX_SCRIPT).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess script " + string + " is not in ISO 15924 list.");
            return false;
        }
        return true;
    }

    private boolean checkCountry(String string) {
        if (!Pattern.compile(REGEX_COUNTRY).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess country " + string + " is not in ISO 3166-1 list.");
            return false;
        }
        return true;
    }

    private boolean checkOrientation(String string) {
        if (!Pattern.compile(REGEX_ORIENTATION).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess orientation " + string + " is not in {vertical, horizontal} list.");
            return false;
        }
        return true;
    }

    private boolean checkDeviceType(String string) {
        if (!Pattern.compile(REGEX_DEVICE_TYPE).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess deviceType " + string + " is not in {phone, tablet, car, tv, wearable, liteWearable, 2in1} list.");
            return false;
        }
        return true;
    }

    private boolean checkScreenDensity(String string) {
        if (!Pattern.compile(REGEX_SCREEN_DENSITY).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess screenDensity " + string + " is not in {sdpi, mdpi, ldpi, xldpi, xxldpi} list.");
            return false;
        }
        return true;
    }

    private boolean checkColorMode(String string) {
        if (!Pattern.compile(REGEX_COLOR_MODE).matcher(string).matches()) {
            LOG.error("Compressor::compressProcess colorMode " + string + " is not in {light, dark} list.");
            return false;
        }
        return true;
    }

    private boolean checkColorModeOrShape(String string) {
        if (Pattern.compile(REGEX_COLOR_MODE).matcher(string).matches() || Pattern.compile(REGEX_SHAPE).matcher(string).matches()) {
            return true;
        }
        LOG.error("Compressor::compressProcess " + string + " is neither in colorMode list {light, dark} nor in shape list {circle}.");
        return false;
    }

    private boolean checkShape(String string) {
        if (Pattern.compile(REGEX_SHAPE).matcher(string).matches()) {
            return true;
        }
        LOG.error("Compressor::compressProcess shape" + string + " is not in {circle} list.");
        return false;
    }

    private boolean isPicturing(String string, Utility utility) {
        boolean bl = false;
        if (string == null || string.isEmpty()) {
            return bl;
        }
        if (!string.endsWith(PNG_SUFFIX) && !string.endsWith(UPPERCASE_PNG_SUFFIX)) {
            LOG.error("isPicturing: the suffix is not .png or .PNG.");
            return false;
        }
        int n = string.lastIndexOf("-");
        if (n < 0) {
            LOG.error("isPicturing: the entry card naming format is invalid and should be separated by '-'.");
            return false;
        }
        String string2 = string.substring(0, n);
        if (!utility.getFormNameList().contains(string2)) {
            LOG.error("isPicturing: the name is not same as formName, name: " + string2 + " is not in " + utility.getFormNameList().toString() + ".");
            return false;
        }
        String string3 = string.substring(n + 1, string.lastIndexOf("."));
        if (!this.supportDimensionsList.contains(string3)) {
            LOG.error("isPicturing: the dimension: " + string3 + " is invalid, is not in the following list: {1X2, 2X2, 2X4, 4X4, 1X1, 6X4}.");
            return false;
        }
        return true;
    }

    private void getFileList(String string) throws BundleException {
        File file = new File(string);
        if (!file.exists()) {
            LOG.error("getFileList: file is not exists.");
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            LOG.error("getFileList: no file in this file path.");
            return;
        }
        for (File file2 : fileArray) {
            try {
                if (file2.isFile()) {
                    if (file2.getName().endsWith(".DS_Store")) {
                        Compressor.deleteFile(file2.getCanonicalPath());
                        continue;
                    }
                    String string2 = file2.getParentFile().getName();
                    if (!ENTRYCARD_SNAPSHOT_NAME.equals(string2)) {
                        LOG.error("The level-4 directory of EntryCard must be named as snapshot, but current is: " + string2 + ".");
                        throw new BundleException("The level-4 directory of EntryCard must be named as snapshot, but current is: " + string2 + ".");
                    }
                    this.fileNameList.add(file2.getCanonicalPath());
                    continue;
                }
                if (file2.isDirectory()) {
                    this.getFileList(file2.getCanonicalPath());
                    continue;
                }
                LOG.error("It's not file or directory.");
            }
            catch (IOException iOException) {
                LOG.error("IOException error: " + iOException.getMessage());
                return;
            }
        }
    }

    private void checkContain2x2EntryCard(File file) throws IOException, BundleException {
        if (!file.exists()) {
            LOG.error("checkContain2x2EntryCard: file is not exist: " + file.getName() + ".");
            throw new BundleException("checkContain2x2EntryCard: file is not exist.");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            LOG.error("checkContain2x2EntryCard: no file in this file path.");
            throw new BundleException("checkContain2x2EntryCard: no file in this file path.");
        }
        for (File file2 : fileArray) {
            if (!file2.isFile() || !file2.getName().contains(PIC_2X2)) continue;
            return;
        }
        this.mIsContain2x2EntryCard = false;
        LOG.error("checkContain2x2EntryCard: must contain 2x2 entryCard, please check it in " + file.getCanonicalPath() + ".");
        throw new BundleException("checkContain2x2EntryCard: must contain 2x2 entryCard, please check it in " + file.getCanonicalPath() + ".");
    }

    private void pathToFile(Utility utility, String string, String string2, boolean bl) throws BundleException {
        if (string.isEmpty()) {
            return;
        }
        if (bl && LIBS_DIR_NAME.equals(string2)) {
            this.compressNativeLibsParallel(string, string2, utility.getCompressLevel());
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.compressDirectory(utility, file2, string2, bl);
                    continue;
                }
                if (bl) {
                    this.compressFile(utility, file2, string2, bl);
                    continue;
                }
                this.compressFile(utility, file2, string2, bl);
            }
        } else {
            this.compressFile(utility, file, string2, bl);
        }
    }

    private void compressNativeLibsParallel(String string, String string2, int n) throws BundleException {
        try {
            int n2 = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            ParallelScatterZipCreator parallelScatterZipCreator = new ParallelScatterZipCreator(threadPoolExecutor, new DefaultBackingStoreSupplier(null), n);
            File file = new File(string);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    return;
                }
                for (File file2 : fileArray) {
                    this.addArchiveEntry(file2, string2, parallelScatterZipCreator);
                }
            } else {
                this.addArchiveEntry(file, string2, parallelScatterZipCreator);
            }
            parallelScatterZipCreator.writeTo(this.zipOut);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            String string3 = "Compressor::compressNativeLibsParallel exception: " + exception.getMessage();
            LOG.error(string3);
            throw new BundleException(string3);
        }
    }

    private void addArchiveEntry(File file, String string, ParallelScatterZipCreator parallelScatterZipCreator) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                this.addArchiveEntry(file2, string + file.getName() + File.separator, parallelScatterZipCreator);
            }
        } else {
            String string2 = (string + file.getName()).replace(File.separator, LINUX_FILE_SEPARATOR);
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(string2);
            zipArchiveEntry.setMethod(8);
            InputStreamSupplier inputStreamSupplier = () -> {
                try {
                    return Files.newInputStream(file.toPath(), new OpenOption[0]);
                }
                catch (IOException iOException) {
                    LOG.error("Compressor::compressNativeLibsParallel exception: " + iOException.getMessage());
                    return null;
                }
            };
            parallelScatterZipCreator.addArchiveEntry(zipArchiveEntry, inputStreamSupplier);
        }
    }

    private void pathToFileResMode(Utility utility, String string, String string2, boolean bl) throws BundleException {
        if (string.isEmpty()) {
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                if (!this.list.contains(file2.getName())) continue;
                if (file2.isDirectory()) {
                    this.compressDirectory(utility, file2, string2, bl);
                    continue;
                }
                if (bl) {
                    this.compressFile(utility, file2, string2, bl);
                    continue;
                }
                this.compressFile(utility, file2, string2, bl);
            }
        } else {
            this.compressFile(utility, file, string2, bl);
        }
    }

    private void compressDirectory(Utility utility, File file, String string, boolean bl) throws BundleException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.compressDirectory(utility, file2, string + file.getName() + File.separator, bl);
                continue;
            }
            this.compressFile(utility, file2, string + file.getName() + File.separator, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(File file, ZipOutputStream zipOutputStream, String string, boolean bl) {
        FileInputStream fileInputStream = null;
        try {
            byte[] byArray = new byte[40960];
            if (file.isFile()) {
                int n;
                ZipEntry zipEntry = this.getStoredZipEntry(file, string);
                zipOutputStream.putNextEntry(zipEntry);
                fileInputStream = new FileInputStream(file);
                while ((n = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
            } else {
                File[] fileArray = file.listFiles();
                if (fileArray == null || fileArray.length == 0) {
                    if (bl) {
                        if (!string.isEmpty()) {
                            ZipEntry zipEntry = this.getStoredZipEntry(file, string + LINUX_FILE_SEPARATOR);
                            zipOutputStream.putNextEntry(zipEntry);
                        } else {
                            ZipEntry zipEntry = this.getStoredZipEntry(file, string);
                            zipOutputStream.putNextEntry(zipEntry);
                        }
                        zipOutputStream.closeEntry();
                    }
                } else {
                    for (File file2 : fileArray) {
                        if (bl) {
                            this.isNameEmpty(zipOutputStream, string, bl, file2);
                            continue;
                        }
                        this.compress(file2, zipOutputStream, file2.getName(), bl);
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.error("Compressor::compressFile file not found exception.");
        }
        catch (IOException iOException) {
            LOG.error("Compressor::compressFile io exception: " + iOException.getMessage());
        }
        catch (BundleException bundleException) {
            LOG.error("Compressor::compressFile bundle exception" + bundleException.getMessage());
        }
        finally {
            Utility.closeStream(fileInputStream);
        }
    }

    private ZipEntry getStoredZipEntry(File file, String string) throws BundleException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setMethod(0);
        zipEntry.setCompressedSize(file.length());
        zipEntry.setSize(file.length());
        CRC32 cRC32 = this.getCrcFromFile(file);
        zipEntry.setCrc(cRC32.getValue());
        return zipEntry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CRC32 getCrcFromFile(File file) throws BundleException {
        FileInputStream fileInputStream = null;
        CRC32 cRC32 = new CRC32();
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[40960];
            int n = fileInputStream.read(byArray);
            while (n > 0) {
                cRC32.update(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LOG.error("Uncompressor::getCrcFromFile file not found exception.");
                throw new BundleException("Get Crc from file failed.");
                catch (IOException iOException) {
                    LOG.error("Uncompressor::getCrcFromFile io exception: " + iOException.getMessage());
                    throw new BundleException("Get Crc from file failed.");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileInputStream);
        return cRC32;
    }

    private void isNameEmpty(ZipOutputStream zipOutputStream, String string, boolean bl, File file) {
        if (!string.isEmpty()) {
            this.compress(file, zipOutputStream, string + LINUX_FILE_SEPARATOR + file.getName(), bl);
        } else {
            this.compress(file, zipOutputStream, file.getName(), bl);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compressFile(Utility utility, File file, String string, boolean bl) throws BundleException {
        ZipArchiveEntry zipArchiveEntry;
        FileInputStream fileInputStream;
        BufferedInputStream bufferedInputStream;
        block9: {
            bufferedInputStream = null;
            fileInputStream = null;
            String string2 = (string + file.getName()).replace(File.separator, LINUX_FILE_SEPARATOR);
            zipArchiveEntry = new ZipArchiveEntry(string2);
            this.isEntryOpen = true;
            if (string2.contains(RAW_FILE_PATH) || string2.contains(RES_FILE_PATH) || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(JSON_SUFFIX) || string2.equals("encrypt.json")) break block9;
            zipArchiveEntry.setMethod(0);
            if (!this.jsonSpecialProcess(utility, file, zipArchiveEntry)) break block9;
            Utility.closeStream(bufferedInputStream);
            Utility.closeStream(fileInputStream);
            return;
        }
        try {
            Object object;
            if (bl) {
                zipArchiveEntry.setMethod(8);
            } else {
                zipArchiveEntry.setMethod(0);
                zipArchiveEntry.setCompressedSize(file.length());
                zipArchiveEntry.setSize(file.length());
                object = this.getCrcFromFile(utility, file);
                zipArchiveEntry.setCrc(((CRC32)object).getValue());
            }
            this.zipOut.putArchiveEntry(zipArchiveEntry);
            object = new byte[40960];
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n = bufferedInputStream.read((byte[])object);
            while (n > 0) {
                this.zipOut.write((byte[])object, 0, n);
                n = bufferedInputStream.read((byte[])object);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new BundleException("CoompressFile failed.");
                catch (IOException iOException) {
                    LOG.error("Compressor::compressFile io exception: " + iOException.getMessage());
                    throw new BundleException("CoompressFile failed.");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(bufferedInputStream);
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(bufferedInputStream);
        Utility.closeStream(fileInputStream);
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isModuleHap(String string) throws BundleException {
        ZipInputStream zipInputStream;
        FileInputStream fileInputStream;
        block7: {
            boolean bl;
            block6: {
                if (!string.toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) {
                    return true;
                }
                fileInputStream = null;
                zipInputStream = null;
                ZipEntry zipEntry = null;
                try {
                    fileInputStream = new FileInputStream(string);
                    zipInputStream = new ZipInputStream(fileInputStream);
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        if (!MODULE_JSON.equals(zipEntry.getName().toLowerCase())) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (IOException iOException) {
                    try {
                        LOG.error("Compressor::isModuleHap io exception: " + iOException.getMessage());
                        throw new BundleException("Compressor::isModuleHap failed.");
                    }
                    catch (Throwable throwable) {
                        Utility.closeStream(fileInputStream);
                        Utility.closeStream(zipInputStream);
                        throw throwable;
                    }
                }
            }
            Utility.closeStream(fileInputStream);
            Utility.closeStream(zipInputStream);
            return bl;
        }
        Utility.closeStream(fileInputStream);
        Utility.closeStream(zipInputStream);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CRC32 getCrcFromFile(Utility utility, File file) throws BundleException {
        FileInputStream fileInputStream = null;
        CRC32 cRC32 = new CRC32();
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[40960];
            int n = fileInputStream.read(byArray);
            while (n > 0) {
                cRC32.update(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                LOG.error("Compressor::getCrcFromFile FileNotFoundException");
                throw new BundleException("Get Crc from file failed: " + file.getName());
                catch (IOException iOException) {
                    LOG.error("Compressor::getCrcFromFile io exception: " + iOException.getMessage());
                    throw new BundleException("Get Crc from file failed.");
                }
            }
            catch (Throwable throwable) {
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(fileInputStream);
        return cRC32;
    }

    private void parsePackInfoJsonFile(Utility utility, String string) throws BundleException {
        try {
            String string2 = FileUtils.getFileContent(string).get();
            ArrayList<String> arrayList = new ArrayList<String>();
            ModuleJsonUtil.parsePackInfoFormsName(string2, arrayList, this.formNamesList);
            for (String string3 : arrayList) {
                if (string3.isEmpty()) {
                    LOG.error("Compressor::infoSpecialJsonFileProcess form name is empty.");
                    continue;
                }
                utility.addFormNameList(string3);
            }
        }
        catch (JSONException jSONException) {
            LOG.error("Compressor::infoSpecialJsonFileProcess json Path: " + string + "json exception: " + jSONException.getMessage());
        }
    }

    private void infoSpecialProcess(Utility utility, File file) throws BundleException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            bufferedReader.mark((int)file.length() + 1);
            this.parsePackModuleName(bufferedReader, utility);
            bufferedReader.reset();
            this.parseDeviceType(bufferedReader, utility);
            bufferedReader.reset();
            Pattern pattern = Pattern.compile(System.lineSeparator());
            String string = bufferedReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            while (string != null) {
                Matcher matcher = pattern.matcher(string.trim());
                String string2 = matcher.replaceAll("");
                stringBuilder.append(string2);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            try {
                LOG.error("Compressor::jsonSpecialProcess io exception: " + iOException.getMessage());
                throw new BundleException("Json special process failed.");
            }
            catch (Throwable throwable) {
                Utility.closeStream(bufferedReader);
                Utility.closeStream(inputStreamReader);
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
        }
        Utility.closeStream(bufferedReader);
        Utility.closeStream(inputStreamReader);
        Utility.closeStream(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jsonSpecialProcess(Utility utility, File file, ZipArchiveEntry zipArchiveEntry) throws BundleException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            Object object;
            Object object2;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            bufferedReader.mark((int)file.length() + 1);
            bufferedReader.reset();
            Optional<String> optional = FileUtils.getFileContent(utility.getJsonPath());
            String string = optional.get();
            String string2 = new File(utility.getJsonPath()).getName().toLowerCase(Locale.ENGLISH);
            if (CONFIG_JSON.equals(string2)) {
                this.parseCompressNativeLibs(bufferedReader, utility);
                utility.setModuleName(ModuleJsonUtil.parseFaModuleName(string));
            } else if (MODULE_JSON.equals(string2)) {
                utility.setIsCompressNativeLibs(ModuleJsonUtil.stageIsCompressNativeLibs(string));
                utility.setModuleName(ModuleJsonUtil.parseStageModuleName(string));
            } else if (PATCH_JSON.equals(string2)) {
                utility.setModuleName(ModuleJsonUtil.parsePatchModuleName(string));
            }
            bufferedReader.reset();
            this.parseDeviceType(bufferedReader, utility);
            bufferedReader.reset();
            Pattern pattern = Pattern.compile(System.lineSeparator());
            String string3 = bufferedReader.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            while (string3 != null) {
                object2 = pattern.matcher(string3.trim());
                object = ((Matcher)object2).replaceAll("");
                stringBuilder.append((String)object);
                string3 = bufferedReader.readLine();
            }
            object2 = JSON.parse(stringBuilder.toString());
            object = JSON.toJSONBytes(object2, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
            CRC32 cRC32 = new CRC32();
            cRC32.update((byte[])object);
            zipArchiveEntry.setCrc(cRC32.getValue());
            zipArchiveEntry.setSize(((Object)object).length);
            zipArchiveEntry.setCompressedSize(((Object)object).length);
            this.zipOut.putArchiveEntry(zipArchiveEntry);
            this.zipOut.write((byte[])object);
        }
        catch (JSONException | IOException exception) {
            boolean bl;
            try {
                LOG.error("Compressor::jsonSpecialProcess io exception: " + exception.getMessage());
                LOG.warning("Json format err: " + file.getAbsolutePath());
                bl = false;
            }
            catch (Throwable throwable) {
                Utility.closeStream(bufferedReader);
                Utility.closeStream(inputStreamReader);
                Utility.closeStream(fileInputStream);
                throw throwable;
            }
            Utility.closeStream(bufferedReader);
            Utility.closeStream(inputStreamReader);
            Utility.closeStream(fileInputStream);
            return bl;
        }
        Utility.closeStream(bufferedReader);
        Utility.closeStream(inputStreamReader);
        Utility.closeStream(fileInputStream);
        return true;
    }

    private void parsePackModuleName(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains(DISTRO) || string.contains(JSON_END) || !string.contains(MODULE_NAME_NEW) && !string.contains(MODULE_NAME)) continue;
                this.getModuleNameFromString(string, utility);
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::parseModuleName io exception: " + iOException.getMessage());
            throw new BundleException("Parse module name failed.");
        }
    }

    private void parsePackFormName(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains("abilities") || string.contains(FORMS) || string.contains(JSON_END) || !string.contains(NAME)) continue;
                this.getNameFromString(string, utility);
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::parseModuleName io exception: " + iOException.getMessage());
            throw new BundleException("Parse module name failed.");
        }
    }

    private void getNameFromString(String string, Utility utility) throws BundleException {
        try {
            int n = string.lastIndexOf(SEMICOLON);
            if (n <= 0) {
                LOG.error("Compressor::getModuleNameFromString field the json is not standard.");
                throw new BundleException("Parse module name failed, module-name is invalid.");
            }
            int n2 = string.lastIndexOf(SEMICOLON, n - 1) + 1;
            String string2 = string.substring(n2, n);
            if (string2 == null || string2.isEmpty()) {
                LOG.error("Compressor::getModuleNameFromString field module-name is empty.");
                throw new BundleException("Parse module name failed, module-name is empty.");
            }
            String[] stringArray = string2.split("\\.");
            if (stringArray.length <= 1) {
                this.formNamesList.add(string2);
                utility.addFormNameList(string2);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LOG.error("Compressor::parseModuleName field module-name is fault: " + stringIndexOutOfBoundsException.getMessage());
            throw new BundleException("Parse module name failed, module-name is invalid.");
        }
    }

    private void getModuleNameFromString(String string, Utility utility) throws BundleException {
        try {
            int n = string.lastIndexOf(SEMICOLON);
            if (n <= 0) {
                LOG.error("Compressor::getModuleNameFromString field the json is not standard.");
                throw new BundleException("Parse module name failed, module-name is invalid.");
            }
            int n2 = string.lastIndexOf(SEMICOLON, n - 1) + 1;
            String string2 = string.substring(n2, n);
            this.list.add(string2);
            if (string2 == null || string2.isEmpty()) {
                LOG.error("Compressor::getModuleNameFromString field module-name is empty.");
                throw new BundleException("Parse module name failed, module-name is empty.");
            }
            utility.setModuleName(string2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LOG.error("Compressor::parseModuleName field module-name is fault: " + stringIndexOutOfBoundsException.getMessage());
            throw new BundleException("Parse module name failed, module-name is invalid.");
        }
    }

    private void parseCompressNativeLibs(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains(COMPRESS_NATIVE_LIBS) || !string.contains("true")) continue;
                utility.setIsCompressNativeLibs(true);
                break;
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::parseCompressNativeLibs io exception: " + iOException.getMessage());
            throw new BundleException("Parse compress native libs failed.");
        }
    }

    private void closeZipOutputStream() {
        try {
            if (this.zipOut != null) {
                this.zipOut.flush();
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::closeZipOutputStream flush exception " + iOException.getMessage());
        }
        try {
            if (this.zipOut != null && this.isEntryOpen) {
                this.zipOut.closeArchiveEntry();
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::closeZipOutputStream close entry io exception " + iOException.getMessage());
        }
        try {
            if (this.zipOut != null) {
                this.zipOut.finish();
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::closeZipOutputStream finish exception " + iOException.getMessage());
        }
    }

    private void parseDeviceType(BufferedReader bufferedReader, Utility utility) throws BundleException {
        String string = null;
        boolean bl = false;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (!bl) {
                    if (!string.contains(DEVICE_TYPE)) continue;
                    bl = true;
                    continue;
                }
                if (!string.contains(JSON_END)) {
                    utility.setDeviceType(string);
                }
                break;
            }
        }
        catch (IOException iOException) {
            LOG.error("Compressor::parseDeviceType io exception: " + iOException.getMessage());
            throw new BundleException("Parse device type failed.");
        }
    }

    private boolean checkHapIsValid(List<String> list, boolean bl) throws BundleException {
        Object object;
        ArrayList<HapVerifyInfo> arrayList = new ArrayList<HapVerifyInfo>();
        for (String object2 : list) {
            if (object2.isEmpty()) {
                LOG.error("Compressor::checkHapIsValid input wrong hap file.");
                throw new BundleException("Compressor::checkHapIsValid input wrong hap file.");
            }
            object = new File(object2);
            String string = ((File)object).getName();
            if (string.isEmpty()) {
                LOG.error("Compressor::checkHapIsValid get file name failed.");
                throw new BundleException("Compressor::checkHapIsValid get file name failed.");
            }
            if (!string.toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX) && !string.toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX)) {
                LOG.error("Compressor::checkHapIsValid input wrong hap file.");
                throw new BundleException("Compressor::checkHapIsValid input wrong hap file.");
            }
            if (Compressor.isModuleHap(object2)) {
                arrayList.add(Compressor.parseStageHapVerifyInfo(object2));
            } else {
                arrayList.add(Compressor.parseFAHapVerifyInfo(object2));
            }
            if (arrayList.isEmpty()) continue;
            this.hapVerifyInfoMap.put(Compressor.getFileNameByPath(object2), (HapVerifyInfo)arrayList.get(arrayList.size() - 1));
        }
        if (bl) {
            boolean bl2 = Compressor.checkSharedAppIsValid(arrayList);
            if (!bl2) {
                return false;
            }
            if (!isOverlay) {
                return true;
            }
        } else {
            for (HapVerifyInfo hapVerifyInfo : arrayList) {
                object = hapVerifyInfo.getBundleType();
                if (!TYPE_SHARED.equals(object)) continue;
                LOG.error("Compressor::checkHapIsValid only one item can be entered in the -hsp-path when bundleType is shared.");
                return false;
            }
        }
        Compressor.setAtomicServiceFileSizeLimit(arrayList);
        return HapVerify.checkHapIsValid(arrayList);
    }

    public static HapVerifyInfo parseStageHapVerifyInfo(String string) throws BundleException {
        HapVerifyInfo hapVerifyInfo = Compressor.readStageHapVerifyInfo(string);
        hapVerifyInfo.setStageModule(true);
        ModuleJsonUtil.parseStageHapVerifyInfo(hapVerifyInfo);
        hapVerifyInfo.setFileLength(FileUtils.getFileSize(string));
        File file = new File(string);
        String string2 = file.getName();
        if (string2.toLowerCase(Locale.ENGLISH).endsWith(HAP_SUFFIX)) {
            hapVerifyInfo.setFileType(HAP_SUFFIX);
        } else if (string2.toLowerCase(Locale.ENGLISH).endsWith(HSP_SUFFIX)) {
            hapVerifyInfo.setFileType(HSP_SUFFIX);
        }
        return hapVerifyInfo;
    }

    public static void setAtomicServiceFileSizeLimit(List<HapVerifyInfo> list) {
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (!hapVerifyInfo.getBundleType().equals(ATOMIC_SERVICE)) continue;
            hapVerifyInfo.setEntrySizeLimit(Compressor.getEntryModuleSizeLimit());
            hapVerifyInfo.setNotEntrySizeLimit(Compressor.getNotEntryModuleSizeLimit());
            hapVerifyInfo.setSumSizeLimit(Compressor.getSumModuleSizeLimit());
        }
    }

    public static HapVerifyInfo parseFAHapVerifyInfo(String string) throws BundleException {
        HapVerifyInfo hapVerifyInfo = Compressor.readFAHapVerifyInfo(string);
        hapVerifyInfo.setStageModule(false);
        hapVerifyInfo.setFileLength(FileUtils.getFileSize(string));
        ModuleJsonUtil.parseFAHapVerifyInfo(hapVerifyInfo);
        return hapVerifyInfo;
    }

    public static HapVerifyInfo readStageHapVerifyInfo(String string) throws BundleException {
        HapVerifyInfo hapVerifyInfo = new HapVerifyInfo();
        ZipFile zipFile = null;
        try {
            File file = new File(string);
            zipFile = new ZipFile(file);
            hapVerifyInfo.setResourceMap(FileUtils.getProfileJson(zipFile));
            hapVerifyInfo.setProfileStr(FileUtils.getFileStringFromZip(MODULE_JSON, zipFile));
        }
        catch (IOException iOException) {
            try {
                LOG.error("FileUtil::parseStageHapVerifyInfo file not available.");
                throw new BundleException("FileUtil::parseStageHapVerifyInfo file not available.");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        return hapVerifyInfo;
    }

    public static HapVerifyInfo readFAHapVerifyInfo(String string) throws BundleException {
        HapVerifyInfo hapVerifyInfo = new HapVerifyInfo();
        ZipFile zipFile = null;
        try {
            File file = new File(string);
            zipFile = new ZipFile(file);
            hapVerifyInfo.setProfileStr(FileUtils.getFileStringFromZip(CONFIG_JSON, zipFile));
        }
        catch (IOException iOException) {
            try {
                LOG.error("FileUtil::parseStageHapVerifyInfo file not available.");
                throw new BundleException("FileUtil::parseStageHapVerifyInfo file not available.");
            }
            catch (Throwable throwable) {
                Utility.closeStream(zipFile);
                throw throwable;
            }
        }
        Utility.closeStream(zipFile);
        return hapVerifyInfo;
    }

    private void compressHQFMode(Utility utility) throws BundleException {
        this.pathToFile(utility, utility.getJsonPath(), "", false);
        if (!utility.getEtsPath().isEmpty()) {
            this.pathToFile(utility, utility.getEtsPath(), ETS_PATH, false);
        }
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, false);
        }
        if (!utility.getResourcesPath().isEmpty()) {
            this.pathToFile(utility, utility.getResourcesPath(), RESOURCES_DIR_NAME, false);
        }
    }

    private void compressAPPQFMode(Utility utility) throws BundleException {
        List<String> list = utility.getFormatedHQFList();
        if (!this.checkHQFIsValid(list)) {
            LOG.error("checkHQFIsValid failed when pack appqf file.");
            throw new BundleException("checkHQFIsValid failed when pack appqf file.");
        }
        for (String string : list) {
            this.pathToFile(utility, string, "", false);
        }
    }

    private boolean checkHQFIsValid(List<String> list) throws BundleException {
        ArrayList<HQFInfo> arrayList = new ArrayList<HQFInfo>();
        for (String string : list) {
            arrayList.add(ModuleJsonUtil.parseHQFInfo(string));
        }
        if (!HQFVerify.checkHQFIsValid(arrayList)) {
            LOG.error("input hqf is invalid.");
            return false;
        }
        return true;
    }

    private void compressHSPMode(Utility utility) throws BundleException {
        String string;
        this.pathToFile(utility, utility.getJsonPath(), "", false);
        this.pathToFile(utility, utility.getProfilePath(), "", false);
        if (!utility.getIndexPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string = "";
            this.pathToFile(utility, utility.getIndexPath(), string, false);
        }
        if (!utility.getLibPath().isEmpty()) {
            this.pathToFile(utility, utility.getLibPath(), LIBS_DIR_NAME, utility.isCompressNativeLibs());
        }
        if (!utility.getANPath().isEmpty()) {
            this.pathToFile(utility, utility.getANPath(), AN_DIR_NAME, false);
        }
        if (!utility.getAPPath().isEmpty()) {
            this.pathToFile(utility, utility.getAPPath(), AP_PATH_NAME, false);
        }
        if (!utility.getFilePath().isEmpty()) {
            this.pathToFile(utility, utility.getFilePath(), "", false);
        }
        if (!utility.getResPath().isEmpty() && !utility.getModuleName().isEmpty()) {
            string = ASSETS_DIR_NAME + utility.getModuleName() + LINUX_FILE_SEPARATOR + RESOURCES_DIR_NAME;
            if (DEVICE_TYPE_FITNESSWATCH.equals(utility.getDeviceType().replace(SEMICOLON, "").trim()) || DEVICE_TYPE_FITNESSWATCH_NEW.equals(utility.getDeviceType().replace(SEMICOLON, "").trim())) {
                string = RES_DIR_NAME;
            }
            this.pathToFile(utility, utility.getResPath(), string, false);
        }
        if (!utility.getResourcesPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string = RESOURCES_DIR_NAME;
            this.pathToFile(utility, utility.getResourcesPath(), string, false);
        }
        if (!utility.getJsPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string = JS_PATH;
            this.pathToFile(utility, utility.getJsPath(), string, false);
        }
        if (!utility.getEtsPath().isEmpty() && Compressor.isModuleJSON(utility.getJsonPath())) {
            string = ETS_PATH;
            this.pathToFile(utility, utility.getEtsPath(), string, false);
        }
        if (!utility.getRpcidPath().isEmpty()) {
            string = "";
            this.pathToFile(utility, utility.getRpcidPath(), string, false);
        }
        if (!utility.getAssetsPath().isEmpty()) {
            this.pathToFile(utility, utility.getAssetsPath(), ASSETS_DIR_NAME, false);
        }
        if (!utility.getBinPath().isEmpty()) {
            this.pathToFile(utility, utility.getBinPath(), "", false);
        }
        if (!utility.getPackInfoPath().isEmpty()) {
            this.pathToFile(utility, utility.getPackInfoPath(), "", false);
        }
        if (!utility.getFormatedDirList().isEmpty()) {
            for (int i = 0; i < utility.getFormatedDirList().size(); ++i) {
                String string2 = new File(utility.getFormatedDirList().get(i)).getName() + File.separator;
                this.pathToFile(utility, utility.getFormatedDirList().get(i), string2, false);
            }
        }
        if (!utility.getPkgContextPath().isEmpty()) {
            this.pathToFile(utility, utility.getPkgContextPath(), "", false);
        }
        this.compressHapModeMultiple(utility);
    }

    private static boolean checkSharedAppIsValid(List<HapVerifyInfo> list) throws BundleException {
        if (list.isEmpty()) {
            LOG.error("no module included");
            return false;
        }
        if (list.size() > 1) {
            LOG.error("Shared app only can contain one module");
            return false;
        }
        for (HapVerifyInfo hapVerifyInfo : list) {
            if (hapVerifyInfo.getTargetBundleName().isEmpty()) continue;
            isOverlay = true;
            return true;
        }
        return HapVerify.checkSharedApppIsValid(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void versionNormalize(Utility utility) {
        ArrayList<VersionNormalizeUtil> arrayList = new ArrayList<VersionNormalizeUtil>();
        Path path = null;
        for (String string : utility.getFormattedHapList()) {
            try {
                String string2;
                path = Files.createTempDirectory(Paths.get(utility.getOutPath(), new String[0]), TEMP_DIR, new FileAttribute[0]);
                Compressor.unpackHap(string, path.toAbsolutePath().toString());
                VersionNormalizeUtil versionNormalizeUtil = new VersionNormalizeUtil();
                File file = new File(path.toAbsolutePath() + LINUX_FILE_SEPARATOR + MODULE_JSON);
                File file2 = new File(path.toAbsolutePath() + LINUX_FILE_SEPARATOR + CONFIG_JSON);
                File file3 = new File(path.toAbsolutePath() + LINUX_FILE_SEPARATOR + PACKINFO_NAME);
                if (file.exists() && file2.exists()) {
                    LOG.error("versionNormalize failed, invalid hap structure.");
                    throw new BundleException("versionNormalize failed, invalid hap structure.");
                }
                if (file.exists()) {
                    string2 = path.resolve(MODULE_JSON).toString();
                    versionNormalizeUtil = this.parseAndModifyModuleJson(string2, utility);
                } else if (file2.exists()) {
                    string2 = path.resolve(CONFIG_JSON).toString();
                    versionNormalizeUtil = this.parseAndModifyConfigJson(string2, utility);
                } else {
                    LOG.error("versionNormalize failed, invalid hap structure.");
                    throw new BundleException("versionNormalize failed, invalid hap structure.");
                }
                if (file3.exists()) {
                    string2 = path.resolve(PACKINFO_NAME).toString();
                    this.parseAndModifyPackInfo(string2, utility);
                }
                Compressor.verifyModuleVersion(versionNormalizeUtil, utility);
                arrayList.add(versionNormalizeUtil);
                string2 = Paths.get(utility.getOutPath(), new String[0]) + LINUX_FILE_SEPARATOR + Paths.get(string, new String[0]).getFileName().toString();
                this.compressDirToHap(path, string2);
            }
            catch (IOException | BundleException exception) {
                LOG.error("versionNormalize failed " + exception.getMessage());
            }
            finally {
                if (path == null) continue;
                Compressor.deleteDirectory(path.toFile());
            }
        }
        Compressor.writeVersionRecord(arrayList, utility.getOutPath());
    }

    private VersionNormalizeUtil parseAndModifyModuleJson(String string, Utility utility) throws BundleException {
        VersionNormalizeUtil versionNormalizeUtil = new VersionNormalizeUtil();
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (!jSONObject.containsKey(APP)) {
                LOG.error("parseAndModifyJson failed, json file not valid.");
                throw new BundleException("parseAndModifyJson failed, json file not valid.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
            if (!jSONObject2.containsKey(VERSION_CODE)) {
                LOG.error("parseAndModifyJson failed, json file not valid.");
                throw new BundleException("parseAndModifyJson failed, json file not valid.");
            }
            if (!jSONObject2.containsKey(VERSION_NAME)) {
                LOG.error("parseAndModifyJson failed, json file not valid.");
                throw new BundleException("parseAndModifyJson failed, json file not valid.");
            }
            versionNormalizeUtil.setOriginVersionCode(jSONObject2.getIntValue(VERSION_CODE));
            versionNormalizeUtil.setOriginVersionName(jSONObject2.getString(VERSION_NAME));
            JSONObject jSONObject3 = jSONObject.getJSONObject(MODULE);
            if (!jSONObject3.containsKey(NAME)) {
                LOG.error("parseAndModifyModuleJson failed, json file not valid.");
                throw new BundleException("parseAndModifyModuleJson failed, json file not valid.");
            }
            versionNormalizeUtil.setModuleName(jSONObject3.getString(NAME));
            jSONObject2.put(VERSION_CODE, (Object)utility.getVersionCode());
            jSONObject2.put(VERSION_NAME, (Object)utility.getVersionName());
            this.writeJson(string, jSONObject);
        }
        catch (IOException iOException) {
            LOG.error("parseAndModifyModuleJson failed, IOException." + iOException.getMessage());
            throw new BundleException("parseAndModifyModuleJson failed, IOException." + iOException.getMessage());
        }
        return versionNormalizeUtil;
    }

    private void parseAndModifyPackInfo(String string, Utility utility) throws BundleException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (jSONObject == null) {
                LOG.warning("parseAndModifyPackInfo failed, json format invalid.");
                return;
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(SUMMARY);
            if (jSONObject2 == null) {
                LOG.warning("parseAndModifyPackInfo failed, summary invalid.");
                return;
            }
            JSONObject jSONObject3 = jSONObject2.getJSONObject(APP);
            if (jSONObject3 == null) {
                LOG.warning("parseAndModifyPackInfo failed, app invalid.");
                return;
            }
            JSONObject jSONObject4 = jSONObject3.getJSONObject(VERSION);
            if (jSONObject4 == null) {
                LOG.warning("parseAndModifyPackInfo failed, version invalid.");
                return;
            }
            jSONObject4.put(CODE, (Object)utility.getVersionCode());
            jSONObject4.put(NAME, (Object)utility.getVersionName());
            this.writeJson(string, jSONObject);
        }
        catch (IOException iOException) {
            LOG.warning("parseAndModifyPackInfo failed, IOException." + iOException.getMessage());
        }
    }

    private void writeJson(String string, JSONObject jSONObject) throws IOException, BundleException {
        BufferedWriter bufferedWriter = null;
        try {
            String string2 = JSON.toJSONString((Object)jSONObject, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), StandardCharsets.UTF_8));
            bufferedWriter.write(string2);
        }
        catch (IOException iOException) {
            LOG.error("Compressor::writeJson failed for IOException " + iOException.getMessage());
            throw new BundleException("Compressor::writeJson failed for IOException");
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
    }

    private VersionNormalizeUtil parseAndModifyConfigJson(String string, Utility utility) throws BundleException {
        VersionNormalizeUtil versionNormalizeUtil = new VersionNormalizeUtil();
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            JSONObject jSONObject = JSON.parseObject((InputStream)fileInputStream, JSONObject.class, new Feature[0]);
            if (!jSONObject.containsKey(APP)) {
                LOG.error("parseAndModifyJson failed, json file not valid.");
                throw new BundleException("parseAndModifyJson failed, json file not valid.");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject(APP);
            if (!jSONObject2.containsKey(VERSION)) {
                LOG.error("parseAndModifyModuleJson failed, json file not valid.");
                throw new BundleException("parseAndModifyModuleJson failed, json file not valid.");
            }
            JSONObject jSONObject3 = jSONObject2.getJSONObject(VERSION);
            if (!jSONObject3.containsKey(CODE)) {
                LOG.error("parseAndModifyModuleJson failed, json file not valid.");
                throw new BundleException("parseAndModifyModuleJson failed, json file not valid.");
            }
            versionNormalizeUtil.setOriginVersionCode(jSONObject3.getIntValue(CODE));
            if (!jSONObject3.containsKey(NAME)) {
                LOG.error("parseAndModifyModuleJson failed, json file not valid.");
                throw new BundleException("parseAndModifyModuleJson failed, json file not valid.");
            }
            versionNormalizeUtil.setOriginVersionName(jSONObject3.getString(NAME));
            JSONObject jSONObject4 = jSONObject.getJSONObject(MODULE);
            if (!jSONObject4.containsKey(NAME)) {
                LOG.error("parseAndModifyModuleJson failed, json file not valid.");
                throw new BundleException("parseAndModifyModuleJson failed, json file not valid.");
            }
            versionNormalizeUtil.setModuleName(jSONObject4.getString(NAME));
            jSONObject3.put(CODE, (Object)utility.getVersionCode());
            jSONObject3.put(NAME, (Object)utility.getVersionName());
            this.writeJson(string, jSONObject);
        }
        catch (IOException iOException) {
            LOG.error("parseAndModifyModuleJson IOException." + iOException.getMessage());
            throw new BundleException("parseAndModifyModuleJson IOException." + iOException.getMessage());
        }
        return versionNormalizeUtil;
    }

    private void compressDirToHap(Path path2, String string) throws IOException, BundleException {
        Utility utility = new Utility();
        utility.setOutPath(string);
        if (string.endsWith(HAP_SUFFIX)) {
            utility.setMode("hap");
        } else if (string.endsWith(HSP_SUFFIX)) {
            utility.setMode("hsp");
        }
        try (Stream<Path> stream = Files.walk(path2, 1, new FileVisitOption[0]);){
            stream.forEach(path -> {
                String string = path.getFileName().toString();
                String string2 = path.toString();
                switch (string) {
                    case "ets": {
                        utility.setEtsPath(string2);
                        break;
                    }
                    case "hnp": {
                        utility.setHnpPath(string2);
                        break;
                    }
                    case "libs": {
                        utility.setLibPath(string2);
                        break;
                    }
                    case "an": {
                        utility.setANPath(string2);
                        break;
                    }
                    case "ap": {
                        utility.setAPPath(string2);
                        break;
                    }
                    case "resources": {
                        utility.setResourcesPath(string2);
                        break;
                    }
                    case "js": {
                        utility.setJsPath(string2);
                        break;
                    }
                    case "assets": {
                        utility.setAssetsPath(string2);
                        break;
                    }
                    case "maple": {
                        utility.setSoDir(string2);
                        break;
                    }
                    case "shared_libs": {
                        utility.setSharedLibsPath(string2);
                        break;
                    }
                    case "config.json": {
                        utility.setJsonPath(string2);
                        break;
                    }
                    case "module.json": {
                        utility.setJsonPath(string2);
                        break;
                    }
                    case "resources.index": {
                        utility.setIndexPath(string2);
                        break;
                    }
                    case "pack.info": {
                        utility.setPackInfoPath(string2);
                        break;
                    }
                    case "rpcid.sc": {
                        utility.setRpcid(string2);
                        break;
                    }
                    case "pkgContextInfo.json": {
                        utility.setPkgContextPath(string2);
                    }
                }
            });
        }
        this.compressProcess(utility);
    }

    private static void deleteDirectory(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                Compressor.deleteDirectory(file2);
            }
        }
        file.delete();
    }

    private static void writeVersionRecord(List<VersionNormalizeUtil> list, String string) {
        String string2 = JSON.toJSONString(list);
        try (FileWriter fileWriter = new FileWriter(string + LINUX_FILE_SEPARATOR + VERSION_RECORD);){
            fileWriter.write(string2);
        }
        catch (IOException iOException) {
            LOG.error("writeVersionRecord failed " + iOException.getMessage());
        }
    }

    private static void verifyModuleVersion(VersionNormalizeUtil versionNormalizeUtil, Utility utility) throws BundleException {
        if (versionNormalizeUtil.getOriginVersionCode() > utility.getVersionCode()) {
            String string = "versionNormalize failed, module " + versionNormalizeUtil.getModuleName() + " version code less than input version code";
            LOG.error(string);
            throw new BundleException(string);
        }
        if (versionNormalizeUtil.getOriginVersionCode() == utility.getVersionCode()) {
            LOG.warning("versionNormalize warning: module " + versionNormalizeUtil.getModuleName() + " version code not changed");
        }
        if (versionNormalizeUtil.getOriginVersionName().equals(utility.getVersionName())) {
            LOG.warning("versionNormalize warning: module " + versionNormalizeUtil.getModuleName() + " version name not changed");
        }
    }

    private static void unpackHap(String string, String string2) throws BundleException {
        try (FileInputStream fileInputStream = new FileInputStream(string);
             ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));){
            ZipEntry zipEntry;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName();
                File file2 = new File(string2, string3);
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    zipInputStream.closeEntry();
                    continue;
                }
                File file3 = file2.getParentFile();
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                Compressor.writeToFile(zipInputStream, file2);
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            LOG.error("unpack hap failed IOException " + iOException.getMessage());
            throw new BundleException("unpack hap failed IOException " + iOException.getMessage());
        }
    }

    private static void writeToFile(ZipInputStream zipInputStream, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[40960];
            while ((n = zipInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
    }

    private static String getFileNameByPath(String string) {
        Path path = Paths.get(string, new String[0]);
        return path.getFileName().toString();
    }

    private void packEncryptJsonFile(Utility utility) throws BundleException {
        if (!utility.getEncryptPath().isEmpty()) {
            this.pathToFile(utility, utility.getEncryptPath(), "", false);
        } else {
            LOG.info("Compressor::packEncryptJsonFile has no encrypt.json");
        }
    }

    private static class VersionNormalizeUtil {
        private int originVersionCode = -1;
        private String originVersionName = "";
        private String moduleName = "";

        private VersionNormalizeUtil() {
        }

        public int getOriginVersionCode() {
            return this.originVersionCode;
        }

        public void setOriginVersionCode(int n) {
            this.originVersionCode = n;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String string) {
            this.moduleName = string;
        }

        public String getOriginVersionName() {
            return this.originVersionName;
        }

        public void setOriginVersionName(String string) {
            this.originVersionName = string;
        }
    }
}

