/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.error;

import com.ohos.hapsigntool.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorMsg {
    private static final Logger log = LogManager.getLogger(ErrorMsg.class);
    private static final String CODE_SIGN_SUB_SYSTEM_CODE = "111";
    private static final String SIGN_TOOL_SUB_SYSTEM_CODE = "110";
    private final String code;
    private final String description;
    private final String cause;
    private final String position;
    private final List<String> solutions;
    private MoreInfo moreInfo;

    public ErrorMsg(String code, String description, String cause, String position, List<String> solutions) {
        this.code = code;
        this.description = description;
        this.cause = cause;
        this.position = position;
        this.solutions = solutions;
        this.moreInfo = new MoreInfo();
    }

    public static Builder getCodeSignErrBuilder() {
        return new Builder(CODE_SIGN_SUB_SYSTEM_CODE);
    }

    public static Builder getSignToolErrBuilder() {
        return new Builder(SIGN_TOOL_SUB_SYSTEM_CODE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator()).append("ERROR: ").append(this.code).append(" ").append(this.description).append(System.lineSeparator()).append("Error Message: ").append(this.cause).append(System.lineSeparator());
        if (!StringUtils.isEmpty(this.position)) {
            sb.append(" At ").append(this.position).append(System.lineSeparator());
        }
        if (this.solutions != null && !this.solutions.isEmpty()) {
            sb.append(System.lineSeparator()).append("* Try the following: ").append(System.lineSeparator());
            for (String s : this.solutions) {
                sb.append(" > ").append(s).append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    public String toString(Object ... args) {
        try {
            return String.format(Locale.ROOT, this.toString(), args);
        }
        catch (MissingFormatArgumentException e) {
            log.error("args format failed: " + args);
            return this.toString();
        }
    }

    public static class Builder {
        private String sysCode;
        private String errCode;
        private String typeCode;
        private String description;
        private String cause;
        private String position;
        private List<String> solutions = new ArrayList<String>();

        public Builder(String sysCode) {
            this.sysCode = sysCode;
        }

        public Builder addErrCode(String errCode) {
            this.errCode = errCode;
            return this;
        }

        public Builder addTypeCode(String typeCode) {
            this.typeCode = typeCode;
            return this;
        }

        public Builder addDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addCause(String cause) {
            this.cause = cause;
            return this;
        }

        public Builder addPosition(String position) {
            this.position = position;
            return this;
        }

        public Builder addSolution(String solution) {
            this.solutions.add(solution);
            return this;
        }

        public ErrorMsg build() {
            return new ErrorMsg(this.sysCode + this.typeCode + this.errCode, this.description, this.cause, this.position, this.solutions);
        }
    }

    static class MoreInfo {
        private String cn;
        private String en;

        MoreInfo() {
        }
    }
}

