/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.signer;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.signer.ISigner;
import com.ohos.hapsigntool.utils.LogUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;

public class LocalSigner
implements ISigner {
    private static final LogUtils LOGGER = new LogUtils(LocalSigner.class);
    private final PrivateKey privateKey;
    private final List<X509Certificate> certificates;

    public LocalSigner(PrivateKey privateKey, List<X509Certificate> certificates) {
        this.privateKey = privateKey;
        this.certificates = certificates;
    }

    @Override
    public byte[] getSignature(byte[] data, String signAlg, AlgorithmParameterSpec parameterSpec) {
        byte[] signData = null;
        try {
            Signature signature = Signature.getInstance(signAlg);
            signature.initSign(this.privateKey);
            if (parameterSpec != null) {
                signature.setParameter(parameterSpec);
            }
            signature.update(data);
            signData = signature.sign();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException exception) {
            LOGGER.debug(exception.getMessage(), exception);
            CustomException.throwException(ERROR.SIGN_ERROR, SignToolErrMsg.SIGNATURE_FAILED.toString(exception.getMessage()));
        }
        return signData;
    }

    @Override
    public List<X509CRL> getCrls() {
        return new ArrayList<X509CRL>();
    }

    @Override
    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }
}

