/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.zip.ZipDataInput;
import com.ohos.hapsigntool.zip.ZipDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferZipDataInput
implements ZipDataInput {
    private final ByteBuffer buffer;
    private final int sourceSize;

    public ByteBufferZipDataInput(ByteBuffer buffer) {
        this(buffer, true);
    }

    private ByteBufferZipDataInput(ByteBuffer buffer, boolean needSlice) {
        this.buffer = needSlice ? buffer.slice() : buffer;
        this.sourceSize = this.buffer.remaining();
    }

    @Override
    public long size() {
        return this.sourceSize;
    }

    @Override
    public void copyTo(long offset, long size, ZipDataOutput output) throws IOException {
        if (size < 0L || size > (long)this.sourceSize) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + this.sourceSize);
        }
        output.write(this.createByteBuffer(offset, (int)size));
    }

    @Override
    public void copyTo(long offset, int size, ByteBuffer buffer) throws IOException {
        buffer.put(this.createByteBuffer(offset, size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer createByteBuffer(long offset, int size) {
        this.checkChunkValid(offset, size);
        int position = (int)offset;
        int limit = position + size;
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.buffer.position(0);
            this.buffer.limit(limit);
            this.buffer.position(position);
            return this.buffer.slice();
        }
    }

    @Override
    public ZipDataInput slice(long offset, long size) {
        if (offset == 0L && size == (long)this.sourceSize) {
            return this;
        }
        if (size < 0L || size > (long)this.sourceSize) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + this.sourceSize);
        }
        ByteBuffer byteBuffer = this.createByteBuffer(offset, (int)size);
        return new ByteBufferZipDataInput(byteBuffer, false);
    }

    private void checkChunkValid(long offset, long size) {
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("sourceSize: " + size);
        }
        if (offset > (long)this.sourceSize) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > source sourceSize (" + this.sourceSize + ")");
        }
        long endOffset = offset + size;
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + sourceSize (" + size + ") overflow");
        }
        if (endOffset > (long)this.sourceSize) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + sourceSize (" + size + ") > source sourceSize (" + this.sourceSize + ")");
        }
    }
}

