/*
 * Decompiled with CFR 0.152.
 */
package com.ohos.hapsigntool.zip;

import com.ohos.hapsigntool.error.CustomException;
import com.ohos.hapsigntool.error.ERROR;
import com.ohos.hapsigntool.error.SignToolErrMsg;
import com.ohos.hapsigntool.error.ZipException;
import com.ohos.hapsigntool.utils.FileUtils;
import com.ohos.hapsigntool.utils.LogUtils;
import com.ohos.hapsigntool.zip.CentralDirectory;
import com.ohos.hapsigntool.zip.EndOfCentralDirectory;
import com.ohos.hapsigntool.zip.EntryType;
import com.ohos.hapsigntool.zip.ZipEntry;
import com.ohos.hapsigntool.zip.ZipEntryData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class Zip {
    private static final LogUtils LOGGER = new LogUtils(Zip.class);
    public static final short FILE_UNCOMPRESS_METHOD_FLAG = 0;
    public static final int MAX_COMMENT_LENGTH = 65535;
    private List<ZipEntry> zipEntries;
    private long signingOffset;
    private byte[] signingBlock;
    private long cDOffset;
    private long eOCDOffset;
    private EndOfCentralDirectory endOfCentralDirectory;
    private String file;

    public Zip(File inputFile) {
        try {
            this.file = inputFile.getCanonicalPath();
            if (!inputFile.exists()) {
                throw new ZipException("read zip file failed");
            }
            long start = System.currentTimeMillis();
            this.endOfCentralDirectory = this.getZipEndOfCentralDirectory(inputFile);
            this.cDOffset = this.endOfCentralDirectory.getOffset();
            long eocdEnd = System.currentTimeMillis();
            LOGGER.debug("getZipEndOfCentralDirectory use {} ms", eocdEnd - start);
            this.getZipCentralDirectory(inputFile);
            long cdEnd = System.currentTimeMillis();
            LOGGER.debug("getZipCentralDirectory use {} ms", cdEnd - start);
            this.getZipEntries(inputFile);
            ZipEntry endEntry = this.zipEntries.get(this.zipEntries.size() - 1);
            CentralDirectory endCD = endEntry.getCentralDirectory();
            ZipEntryData endEntryData = endEntry.getZipEntryData();
            this.signingOffset = endCD.getOffset() + endEntryData.getLength();
            long entryEnd = System.currentTimeMillis();
            LOGGER.debug("getZipEntries use {} ms", entryEnd - start);
            this.signingBlock = this.getSigningBlock(inputFile);
        }
        catch (IOException e) {
            CustomException.throwException(ERROR.ZIP_ERROR, SignToolErrMsg.READ_ZIP_FAILED.toString(e.getMessage()));
        }
    }

    private EndOfCentralDirectory getZipEndOfCentralDirectory(File file) throws IOException {
        if (file.length() < 22L) {
            throw new ZipException("find zip eocd failed");
        }
        int eocdLength = 22;
        this.eOCDOffset = file.length() - (long)eocdLength;
        byte[] bytes = FileUtils.readFileByOffsetAndLength(file, this.eOCDOffset, eocdLength);
        Optional<EndOfCentralDirectory> eocdByBytes = EndOfCentralDirectory.getEOCDByBytes(bytes);
        if (eocdByBytes.isPresent()) {
            return eocdByBytes.get();
        }
        long eocdMaxLength = Math.min(65557L, file.length());
        this.eOCDOffset = file.length() - eocdMaxLength;
        bytes = FileUtils.readFileByOffsetAndLength(file, this.eOCDOffset, eocdMaxLength);
        int start = 0;
        while ((long)start < eocdMaxLength) {
            eocdByBytes = EndOfCentralDirectory.getEOCDByBytes(bytes, start);
            if (eocdByBytes.isPresent()) {
                this.eOCDOffset += (long)start;
                return eocdByBytes.get();
            }
            ++start;
        }
        throw new ZipException("read zip failed: can not find eocd in file");
    }

    private void getZipCentralDirectory(File file) throws IOException {
        int offset;
        CentralDirectory cd;
        this.zipEntries = new ArrayList<ZipEntry>(this.endOfCentralDirectory.getCDTotal());
        byte[] cdBytes = FileUtils.readFileByOffsetAndLength(file, this.cDOffset, this.endOfCentralDirectory.getCDSize());
        if (cdBytes.length < 46) {
            throw new ZipException("find zip cd failed");
        }
        ByteBuffer bf = ByteBuffer.wrap(cdBytes);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        for (offset = 0; offset < cdBytes.length; offset += cd.getLength()) {
            cd = CentralDirectory.getCentralDirectory(bf);
            ZipEntry entry = new ZipEntry();
            entry.setCentralDirectory(cd);
            this.zipEntries.add(entry);
        }
        if ((long)offset + this.cDOffset != this.eOCDOffset) {
            throw new ZipException("cd end offset not equals to eocd offset, maybe this is a zip64 file");
        }
    }

    private byte[] getSigningBlock(File file) throws IOException {
        long size = this.cDOffset - this.signingOffset;
        if (size < 0L) {
            throw new ZipException("signing offset in front of entry end");
        }
        if (size == 0L) {
            return new byte[0];
        }
        return FileUtils.readFileByOffsetAndLength(file, this.signingOffset, size);
    }

    private void getZipEntries(File file) throws IOException {
        for (ZipEntry entry : this.zipEntries) {
            CentralDirectory cd = entry.getCentralDirectory();
            long offset = cd.getOffset();
            long unCompressedSize = cd.getUnCompressedSize();
            long compressedSize = cd.getCompressedSize();
            long fileSize = cd.getMethod() == 0 ? unCompressedSize : compressedSize;
            ZipEntryData zipEntryData = ZipEntryData.getZipEntry(file, offset, fileSize);
            if (this.cDOffset - offset < zipEntryData.getLength()) {
                throw new ZipException("cd offset in front of entry end");
            }
            entry.setZipEntryData(zipEntryData);
        }
    }

    public void toFile(String outFile) {
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            for (ZipEntry entry : this.zipEntries) {
                boolean isSuccess;
                ZipEntryData zipEntryData = entry.getZipEntryData();
                FileUtils.writeByteToOutFile(zipEntryData.getZipEntryHeader().toBytes(), fos);
                if (entry.getZipEntryData().getData() != null) {
                    ByteBuffer bf = ByteBuffer.wrap(entry.getZipEntryData().getData());
                    bf.order(ByteOrder.LITTLE_ENDIAN);
                    isSuccess = FileUtils.writeByteToOutFile(bf.array(), fos);
                } else {
                    isSuccess = FileUtils.appendWriteFileByOffsetToFile(this.file, fos, zipEntryData.getFileOffset(), zipEntryData.getFileSize());
                }
                if (!isSuccess) {
                    throw new ZipException("write zip data failed");
                }
                if (zipEntryData.getDataDescriptor() == null) continue;
                FileUtils.writeByteToOutFile(zipEntryData.getDataDescriptor().toBytes(), fos);
            }
            if (this.signingBlock != null) {
                FileUtils.writeByteToOutFile(this.signingBlock, fos);
            }
            for (ZipEntry entry : this.zipEntries) {
                CentralDirectory cd = entry.getCentralDirectory();
                FileUtils.writeByteToOutFile(cd.toBytes(), fos);
            }
            FileUtils.writeByteToOutFile(this.endOfCentralDirectory.toBytes(), fos);
        }
        catch (IOException e) {
            CustomException.throwException(ERROR.ZIP_ERROR, SignToolErrMsg.WRITE_ZIP_FAILED.toString(e.getMessage()));
        }
    }

    public void alignment(int alignment) {
        try {
            ZipEntry entry;
            ZipEntryData zipEntryData;
            short method;
            this.sort();
            boolean isFirstUnRunnableFile = true;
            Iterator<ZipEntry> iterator = this.zipEntries.iterator();
            while (iterator.hasNext() && ((method = (zipEntryData = (entry = iterator.next()).getZipEntryData()).getZipEntryHeader().getMethod()) == 0 || isFirstUnRunnableFile)) {
                int add;
                int alignBytes;
                EntryType type = entry.getZipEntryData().getType();
                if (type == EntryType.RUNNABLE_FILE && method == 0 || type == EntryType.BIT_MAP) {
                    alignBytes = 4096;
                } else if (isFirstUnRunnableFile) {
                    alignBytes = 4096;
                    isFirstUnRunnableFile = false;
                } else {
                    alignBytes = alignment;
                }
                if ((add = entry.alignment(alignBytes)) <= 0) continue;
                this.resetOffset();
            }
        }
        catch (ZipException e) {
            CustomException.throwException(ERROR.ZIP_ERROR, SignToolErrMsg.ALIGNMENT_ZIP_FAILED.toString(e.getMessage()));
        }
    }

    public void addBitMap(byte[] data) throws ZipException {
        this.zipEntries.removeIf(e -> e.getZipEntryData().getType() == EntryType.BIT_MAP);
        ZipEntry entry = new ZipEntry.Builder().setMethod((short)0).setUncompressedSize(data.length).setCompressedSize(data.length).setFileName(".pages.info").setData(data).build();
        this.zipEntries.add(entry);
    }

    public void removeSignBlock() {
        this.signingBlock = null;
        this.resetOffset();
    }

    private void sort() {
        this.zipEntries.sort((entry1, entry2) -> {
            short entry1Method = entry1.getZipEntryData().getZipEntryHeader().getMethod();
            short entry2Method = entry2.getZipEntryData().getZipEntryHeader().getMethod();
            String entry1FileName = entry1.getZipEntryData().getZipEntryHeader().getFileName();
            String entry2FileName = entry2.getZipEntryData().getZipEntryHeader().getFileName();
            if (entry1Method == 0 && entry2Method == 0) {
                EntryType entry2Type;
                EntryType entry1Type = entry1.getZipEntryData().getType();
                if (entry1Type != (entry2Type = entry2.getZipEntryData().getType())) {
                    return entry1Type.compareTo(entry2Type);
                }
                return entry1FileName.compareTo(entry2FileName);
            }
            if (entry1Method == 0) {
                return -1;
            }
            if (entry2Method == 0) {
                return 1;
            }
            return entry1FileName.compareTo(entry2FileName);
        });
        this.resetOffset();
    }

    private void resetOffset() {
        long offset = 0L;
        long cdLength = 0L;
        for (ZipEntry entry : this.zipEntries) {
            entry.updateLength();
            entry.getCentralDirectory().setOffset(offset);
            offset += entry.getZipEntryData().getLength();
            cdLength += (long)entry.getCentralDirectory().getLength();
        }
        if (this.signingBlock != null) {
            offset += (long)this.signingBlock.length;
        }
        this.cDOffset = offset;
        this.endOfCentralDirectory.setOffset(offset);
        this.endOfCentralDirectory.setCDSize(cdLength);
        this.eOCDOffset = offset += cdLength;
        this.endOfCentralDirectory.setCDTotal(this.zipEntries.size());
        this.endOfCentralDirectory.setThisDiskCDNum(this.zipEntries.size());
    }

    public List<ZipEntry> getZipEntries() {
        return this.zipEntries;
    }

    public void setZipEntries(List<ZipEntry> zipEntries) {
        this.zipEntries = zipEntries;
    }

    public long getSigningOffset() {
        return this.signingOffset;
    }

    public void setSigningOffset(long signingOffset) {
        this.signingOffset = signingOffset;
    }

    public byte[] getSigningBlock() {
        return this.signingBlock;
    }

    public void setSigningBlock(byte[] signingBlock) {
        this.signingBlock = signingBlock;
    }

    public long getCDOffset() {
        return this.cDOffset;
    }

    public void setCDOffset(long cDOffset) {
        this.cDOffset = cDOffset;
    }

    public long getEOCDOffset() {
        return this.eOCDOffset;
    }

    public void setEOCDOffset(long eOCDOffset) {
        this.eOCDOffset = eOCDOffset;
    }

    public EndOfCentralDirectory getEndOfCentralDirectory() {
        return this.endOfCentralDirectory;
    }

    public void setEndOfCentralDirectory(EndOfCentralDirectory endOfCentralDirectory) {
        this.endOfCentralDirectory = endOfCentralDirectory;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

